/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.compile.impl;

import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.rapidoid.util.U;

public class SimpleNameEnvironment
implements INameEnvironment {
    @Override
    public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
        String className = U.join(".", compoundTypeName);
        return className != null ? this.type(className) : null;
    }

    @Override
    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        String type = new String(typeName);
        String pkg = U.join(".", packageName);
        String cls = pkg + "." + type;
        return this.type(cls);
    }

    protected NameEnvironmentAnswer type(String fullclassName) {
        try {
            byte[] classFileBytes = U.classBytes(fullclassName);
            if (classFileBytes == null) {
                return null;
            }
            ClassFileReader binaryType = new ClassFileReader(classFileBytes, null);
            AccessRestriction accessRestriction = null;
            NameEnvironmentAnswer answer = new NameEnvironmentAnswer(binaryType, accessRestriction);
            return answer;
        }
        catch (Exception e) {
            throw U.rte(e);
        }
    }

    @Override
    public boolean isPackage(char[][] parentPackageName, char[] packageName) {
        String pkg = parentPackageName != null ? U.join(".", parentPackageName) + "." + new String(packageName) : new String(packageName);
        return this.isPackage(pkg);
    }

    protected boolean isPackage(String pkg) {
        return true;
    }

    @Override
    public void cleanup() {
    }
}

