/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.data;

import java.util.Map;
import org.rapidoid.buffer.Buf;
import org.rapidoid.bytes.BYTES;
import org.rapidoid.data.Range;
import org.rapidoid.util.U;

public class KeyValueRanges {
    public final Range[] keys;
    public final Range[] values;
    public int count;

    public KeyValueRanges(int capacity) {
        this.keys = new Range[capacity];
        this.values = new Range[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.keys[i] = new Range();
            this.values[i] = new Range();
            this.keys[i].reset();
            this.values[i].reset();
        }
    }

    public void reset() {
        for (int i = 0; i < this.count; ++i) {
            this.keys[i].reset();
            this.values[i].reset();
        }
        this.count = 0;
    }

    public Range get(Buf buf, byte[] key, boolean caseSensitive) {
        for (int i = 0; i < this.count; ++i) {
            if (!BYTES.matches(buf.bytes(), this.keys[i], key, caseSensitive)) continue;
            return this.values[i];
        }
        return null;
    }

    public String toString() {
        return super.toString() + "[" + this.count + "]";
    }

    public int max() {
        return this.keys.length;
    }

    public String str(Buf src) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.count; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("<");
            sb.append(this.keys[i].str(src.bytes()));
            sb.append(":=");
            sb.append(this.values[i].str(src.bytes()));
            sb.append(">");
        }
        sb.append("]");
        return sb.toString();
    }

    public int add() {
        if (this.count >= this.max()) {
            throw U.rte("too many key-values!");
        }
        return this.count++;
    }

    public Map<String, String> toMap(String data) {
        Map<String, String> map = U.map();
        for (int i = 0; i < this.count; ++i) {
            map.put(this.keys[i].get(data), this.values[i].get(data));
        }
        return map;
    }

    public Map<String, String> toMap(Buf src, boolean urlDecodeKeys, boolean urlDecodeVals) {
        Map<String, String> map = U.map();
        for (int i = 0; i < this.count; ++i) {
            String key = this.keys[i].str(src.bytes());
            String val = this.values[i].str(src.bytes());
            if (urlDecodeKeys) {
                key = U.urlDecode(key);
            }
            if (urlDecodeVals) {
                val = U.urlDecode(val);
            }
            map.put(key, val);
        }
        return map;
    }

    public Map<String, byte[]> toBinaryMap(Buf src, boolean urlDecodeKeys) {
        Map<String, byte[]> map = U.map();
        for (int i = 0; i < this.count; ++i) {
            String key = this.keys[i].str(src.bytes());
            byte[] val = this.values[i].bytes(src);
            if (urlDecodeKeys) {
                key = U.urlDecode(key);
            }
            map.put(key, val);
        }
        return map;
    }
}

