/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.data;

import org.rapidoid.buffer.Buf;
import org.rapidoid.bytes.BYTES;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.data.Range;
import org.rapidoid.util.U;

public class Ranges {
    public final Range[] ranges;
    public int count;

    public Ranges(int capacity) {
        this.ranges = new Range[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.ranges[i] = new Range();
            this.ranges[i].reset();
        }
    }

    public Ranges reset() {
        for (int i = 0; i < this.count; ++i) {
            this.ranges[i].reset();
        }
        this.count = 0;
        return this;
    }

    public Range getByPrefix(Bytes bytes, byte[] prefix, boolean caseSensitive) {
        return BYTES.getByPrefix(bytes, this, prefix, caseSensitive);
    }

    public String toString() {
        return super.toString() + "[" + this.count + "]";
    }

    public int max() {
        return this.ranges.length;
    }

    public String str(Bytes bytes) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.count; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("<");
            sb.append(this.ranges[i].str(bytes));
            sb.append(">");
        }
        sb.append("]");
        return sb.toString();
    }

    public String str(Buf buf) {
        return this.str(buf.bytes());
    }

    public int add() {
        if (this.count >= this.max()) {
            throw U.rte("too many key-values!");
        }
        return this.count++;
    }

    public void add(int start, int length) {
        if (this.count >= this.max()) {
            throw U.rte("too many key-values!");
        }
        this.ranges[this.count++].set(start, length);
    }

    public boolean isEmpty() {
        return this.count == 0;
    }
}

