/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.db;

import java.util.List;
import org.rapidoid.db.DB;
import org.rapidoid.util.U;

public abstract class CRUD<E> {
    private final Class<E> clazz;

    private static Class<?> inferEntityClass(String className) {
        String type;
        if (className.endsWith("Service")) {
            type = className.substring(0, className.length() - 7);
        } else if (className.endsWith("Controller")) {
            type = className.substring(0, className.length() - 10);
        } else if (className.endsWith("CRUD")) {
            type = className.substring(0, className.length() - 4);
        } else {
            throw U.rte("Automatic entity detection requires class name suffix to be 'Service', 'Controller' or 'CRUD'");
        }
        Class<?> entityClass = U.getClassIfExists(type);
        U.must(entityClass != null, "Cannot infer entity class for the service: %s", className);
        return entityClass;
    }

    public CRUD() {
        this.clazz = CRUD.inferEntityClass(this.getClass().getCanonicalName());
    }

    public CRUD(Class<E> clazz) {
        this.clazz = clazz;
    }

    public long insert(E record) {
        return DB.insert(record);
    }

    public void update(long id, E record) {
        DB.update(id, record);
    }

    public void delete(long id) {
        DB.delete(id);
    }

    public E get(long id) {
        return DB.get(id, this.clazz);
    }

    public List<E> getAll() {
        return DB.getAll(this.clazz);
    }

    public <T> T read(long id, String column) {
        return (T)DB.read(id, column);
    }
}

