/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.db;

import java.io.File;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.rapidoid.db.Db;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.lambda.Operation;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.util.U;

public class DB {
    private static final Class<Db> DB_IMPL_CLASS = U.getClassIfExists("org.rapidoid.db.DbImpl");
    private static Db defaultDb;
    private static final Map<String, Db> DB_INSTANCES;

    public static Db db() {
        assert (U.must(defaultDb != null, "Database not initialized!"));
        return defaultDb;
    }

    public static Db instance(String dbName) {
        return DB_INSTANCES.get(dbName);
    }

    public static Map<String, Db> instances() {
        return Collections.unmodifiableMap(DB_INSTANCES);
    }

    public static long insert(Object record) {
        return DB.db().insert(record);
    }

    public static void delete(long id) {
        DB.db().delete(id);
    }

    public static <T> T get(long id) {
        return (T)DB.db().get(id);
    }

    public static <T> T get(long id, Class<T> clazz) {
        return DB.db().get(id, clazz);
    }

    public static <E> List<E> getAll(Class<E> clazz) {
        return DB.db().getAll(clazz);
    }

    public static void update(long id, Object record) {
        DB.db().update(id, record);
    }

    public static void update(Object record) {
        DB.db().update(record);
    }

    public static <E> E read(long id, String column) {
        return (E)DB.db().read(id, column);
    }

    public static <E> List<E> find(Predicate<E> match) {
        return DB.db().find(match);
    }

    public static <E> void each(Operation<E> lambda) {
        DB.db().each(lambda);
    }

    public static void transaction(Runnable transaction) {
        DB.db().transaction(transaction);
    }

    public static void save(OutputStream output) {
        DB.db().save(output);
    }

    public static void shutdown() {
        DB.db().shutdown();
    }

    public static long size() {
        return DB.db().size();
    }

    public static boolean isActive() {
        return DB.db().isActive();
    }

    public static void halt() {
        DB.db().halt();
    }

    public static void destroy() {
        DB.db().destroy();
    }

    public static void destroy(String name) {
        DB.instance(name).destroy();
        DB.remove(name);
    }

    public static synchronized void destroyAll() {
        for (Db db : DB_INSTANCES.values()) {
            db.destroy();
        }
        DB_INSTANCES.clear();
        defaultDb = DB.instance("default");
    }

    public static void remove(String name) {
        DB_INSTANCES.remove(name);
        if (name.equals("default")) {
            defaultDb = DB.instance("default");
        }
    }

    static {
        U.must(DB_IMPL_CLASS != null, "Cannot find Db implementation (org.rapidoid.db.DbImpl)!");
        U.must(Db.class.isAssignableFrom(DB_IMPL_CLASS), "org.rapidoid.db.DbImpl must implement org.rapidoid.db.Db!");
        DB_INSTANCES = U.autoExpandingMap(new Mapper<String, Db>(){

            @Override
            public Db map(String name) throws Exception {
                String dbPath = U.option("db", "");
                if (!dbPath.isEmpty() && !dbPath.endsWith(File.separator)) {
                    dbPath = dbPath + File.separator;
                }
                String dbFilename = dbPath + name + ".db";
                return (Db)U.newInstance(DB_IMPL_CLASS, name, dbFilename);
            }
        });
        defaultDb = DB.instance("default");
    }
}

