/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.util.U;

public class HTMLSnippets {
    private static String PAGE_HTML = U.load("page.html");
    private static String FULL_PAGE_HTML = U.load("page-full.html");

    public static HttpExchange writePage(HttpExchange x, String title, String content) {
        String html = U.fillIn(PAGE_HTML, "title", title);
        html = U.fillIn(html, "content", content);
        x.write(html);
        return x;
    }

    public static HttpExchange writeFullPage(HttpExchange x, String title, String content) {
        String html = FULL_PAGE_HTML.replaceAll("\\{\\{title\\}\\}", title).replaceAll("\\{\\{content\\}\\}", content);
        x.write(html);
        return x;
    }

    public static HttpExchange writeErrorPage(HttpExchange x, String title, Throwable err) {
        String content = HTMLSnippets.stackTrace("Stack trace: ", err);
        return HTMLSnippets.writeFullPage(x, title, content);
    }

    private static String stackTrace(String title, Throwable err) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        err.printStackTrace(new PrintStream(buf));
        String trace = buf.toString().replace('$', '_').replaceAll("\r?\n", "<br/>");
        String content = "<h4>" + title + "</h4>" + trace;
        if (err.getCause() != null) {
            content = content + HTMLSnippets.stackTrace("Cause:", err.getCause());
        }
        return content;
    }
}

