/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import org.rapidoid.http.HTTPServer;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.http.HttpExchangeImpl;
import org.rapidoid.http.HttpProtocol;
import org.rapidoid.http.HttpRouter;
import org.rapidoid.http.HttpSession;
import org.rapidoid.http.InMemoryHttpSession;
import org.rapidoid.http.Router;
import org.rapidoid.json.JSON;
import org.rapidoid.net.impl.RapidoidServerLoop;

public class HTTPServerImpl
extends RapidoidServerLoop
implements HTTPServer {
    private final HttpSession session = new InMemoryHttpSession();

    public HTTPServerImpl() {
        super(new HttpProtocol(new HttpRouter()), HttpExchangeImpl.class, null);
        ((HttpProtocol)this.protocol).setSession(this.session);
    }

    @Override
    public HTTPServer route(String cmd, String url, Handler handler) {
        this.router().route(cmd, url, handler);
        return this;
    }

    @Override
    public HTTPServer route(String cmd, String url, String response) {
        this.router().route(cmd, url, HTTPServerImpl.contentHandler(response));
        return this;
    }

    @Override
    public HTTPServer serve(Handler handler) {
        this.router().generic(handler);
        return this;
    }

    @Override
    public HTTPServer serve(String response) {
        return this.serve(HTTPServerImpl.contentHandler(response));
    }

    private Router router() {
        return ((HttpProtocol)this.protocol).getRouter();
    }

    @Override
    public HTTPServer get(String url, Handler handler) {
        return this.route("GET", url, handler);
    }

    @Override
    public HTTPServer post(String url, Handler handler) {
        return this.route("POST", url, handler);
    }

    @Override
    public HTTPServer put(String url, Handler handler) {
        return this.route("PUT", url, handler);
    }

    @Override
    public HTTPServer delete(String url, Handler handler) {
        return this.route("DELETE", url, handler);
    }

    private static Handler contentHandler(String response) {
        final byte[] bytes = response.getBytes();
        return new Handler(){

            @Override
            public Object handle(HttpExchange x) {
                x.html();
                return bytes;
            }
        };
    }

    @Override
    public HTTPServer start() {
        super.start();
        JSON.warmup();
        return this;
    }

    @Override
    public HTTPServer shutdown() {
        super.shutdown();
        return this;
    }
}

