/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import java.io.File;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.rapidoid.data.BinaryMultiData;
import org.rapidoid.data.Data;
import org.rapidoid.data.KeyValueRanges;
import org.rapidoid.data.MultiData;
import org.rapidoid.data.Range;
import org.rapidoid.data.Ranges;
import org.rapidoid.http.HTMLSnippets;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.http.HttpExchangeBody;
import org.rapidoid.http.HttpExchangeHeaders;
import org.rapidoid.http.HttpHeader;
import org.rapidoid.http.HttpOutputStream;
import org.rapidoid.http.HttpParser;
import org.rapidoid.http.HttpResponse;
import org.rapidoid.http.HttpResponses;
import org.rapidoid.http.HttpSession;
import org.rapidoid.http.UserInfo;
import org.rapidoid.inject.IoC;
import org.rapidoid.net.impl.ConnState;
import org.rapidoid.net.impl.DefaultExchange;
import org.rapidoid.net.mime.MediaType;
import org.rapidoid.util.Constants;
import org.rapidoid.util.U;
import org.rapidoid.util.UTILS;
import org.rapidoid.wrap.Bool;

public class HttpExchangeImpl
extends DefaultExchange<HttpExchange, HttpExchangeBody>
implements HttpExchange,
Constants {
    private static final String SESSION_USER = "_user";
    private static final String SESSION_COOKIE = "JSESSIONID";
    private static final HttpParser PARSER = IoC.singleton(HttpParser.class);
    private static final byte[] HEADER_SEP = ": ".getBytes();
    final Range uri = new Range();
    final Range verb = new Range();
    final Range path = new Range();
    final Range query = new Range();
    final Range protocol = new Range();
    final Ranges headers = new Ranges(50);
    private final KeyValueRanges params = new KeyValueRanges(50);
    private final KeyValueRanges headersKV = new KeyValueRanges(50);
    private final KeyValueRanges cookies = new KeyValueRanges(50);
    private final KeyValueRanges data = new KeyValueRanges(50);
    private final KeyValueRanges files = new KeyValueRanges(50);
    final Range body = new Range();
    final Bool isGet = new Bool();
    final Bool isKeepAlive = new Bool();
    private boolean parsedParams;
    private boolean parsedHeaders;
    private boolean parsedBody;
    private int bodyPos;
    private boolean writesBody;
    private boolean hasContentType;
    private int startingPos;
    private HttpResponses responses;
    final Range multipartBoundary = new Range();
    private final Range subpathRange = new Range();
    private final Data _body;
    private final Data _uri;
    private final Data _verb;
    private final Data _path;
    private final Data _subpath;
    private final Data _query;
    private final Data _protocol;
    private final MultiData _params;
    private final MultiData _headers;
    private final MultiData _cookies;
    private final MultiData _data;
    private final BinaryMultiData _files;
    private int responseCode;
    private String sessionId;
    private HttpSession session;

    public HttpExchangeImpl() {
        this.reset();
        this._body = this.data(this.body);
        this._uri = this.data(this.uri);
        this._verb = this.data(this.verb);
        this._path = this.decodedData(this.path);
        this._subpath = this.decodedData(this.subpathRange);
        this._query = this.decodedData(this.query);
        this._protocol = this.data(this.protocol);
        this._params = this.multiData(this.params);
        this._headers = this.multiData(this.headersKV);
        this._cookies = this.multiData(this.cookies);
        this._data = this.multiData(this.data);
        this._files = this.binaryMultiData(this.files);
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.isGet.value = false;
        this.isKeepAlive.value = false;
        this.verb.reset();
        this.uri.reset();
        this.path.reset();
        this.query.reset();
        this.protocol.reset();
        this.body.reset();
        this.multipartBoundary.reset();
        this.params.reset();
        this.headersKV.reset();
        this.headers.reset();
        this.cookies.reset();
        this.data.reset();
        this.files.reset();
        this.parsedParams = false;
        this.parsedHeaders = false;
        this.parsedBody = false;
        this.sessionId = null;
        this.resetResponse();
    }

    private void resetResponse() {
        this.writesBody = false;
        this.bodyPos = -1;
        this.hasContentType = false;
        this.responses = null;
        this.responseCode = -1;
    }

    @Override
    public synchronized MultiData params_() {
        if (!this.parsedParams) {
            if (!this.query.isEmpty()) {
                PARSER.parseParams(this.input(), this.params, this.query_().range());
            }
            this.parsedParams = true;
        }
        return this._params;
    }

    @Override
    public synchronized MultiData headers_() {
        if (!this.parsedHeaders) {
            if (!this.headers.isEmpty()) {
                PARSER.parseHeadersIntoKV(this.input(), this.headers, this.headersKV, this.cookies, this.helper());
            }
            this.parsedHeaders = true;
        }
        return this._headers;
    }

    @Override
    public synchronized MultiData cookies_() {
        if (!this.parsedHeaders) {
            if (!this.headers.isEmpty()) {
                PARSER.parseHeadersIntoKV(this.input(), this.headers, this.headersKV, this.cookies, this.helper());
            }
            this.parsedHeaders = true;
        }
        return this._cookies;
    }

    @Override
    public synchronized MultiData data_() {
        if (!this.parsedBody) {
            PARSER.parseBody(this.input(), this.headersKV, this.body, this.data, this.files, this.helper());
            this.parsedBody = true;
        }
        return this._data;
    }

    @Override
    public synchronized BinaryMultiData files_() {
        if (!this.parsedBody) {
            PARSER.parseBody(this.input(), this.headersKV, this.body, this.data, this.files, this.helper());
            this.parsedBody = true;
        }
        return this._files;
    }

    @Override
    public synchronized Data subpath_() {
        return this._subpath;
    }

    @Override
    public synchronized Data body_() {
        return this._body;
    }

    @Override
    public synchronized Data uri_() {
        return this._uri;
    }

    @Override
    public synchronized Data verb_() {
        return this._verb;
    }

    @Override
    public synchronized Data path_() {
        return this._path;
    }

    @Override
    public synchronized Data protocol_() {
        return this._protocol;
    }

    @Override
    public synchronized Data query_() {
        return this._query;
    }

    public synchronized void setSubpath(int start, int end) {
        this.subpathRange.setInterval(start, end);
    }

    @Override
    public synchronized HttpExchangeImpl done() {
        this.conn.done();
        return this;
    }

    @Override
    public synchronized HttpExchangeBody send() {
        this.conn.send();
        return this;
    }

    public synchronized String toString() {
        return "WebExchange [uri=" + this.uri() + ", verb=" + this.verb() + ", path=" + this.path() + ", subpath=" + this.subpath() + ", query=" + this.query() + ", protocol=" + this.protocol() + ", body=" + this.body() + ", headers=" + this.headers() + ", params=" + this.params() + ", cookies=" + this.cookies() + ", data=" + this.data() + ", files=" + this.files() + "]";
    }

    @Override
    public synchronized String verb() {
        return this.verb_().get();
    }

    @Override
    public synchronized String uri() {
        return this.uri_().get();
    }

    @Override
    public synchronized String path() {
        return this.path_().get();
    }

    @Override
    public synchronized String subpath() {
        return this.subpath_().get();
    }

    @Override
    public synchronized String query() {
        return this.query_().get();
    }

    @Override
    public synchronized String protocol() {
        return this.protocol_().get();
    }

    @Override
    public synchronized String body() {
        return this.body_().get();
    }

    @Override
    public synchronized Map<String, String> params() {
        return this.params_().get();
    }

    @Override
    public synchronized String param(String name) {
        return U.notNull(this.params_().get(name), "PARAM[%s]", name);
    }

    @Override
    public String param(String name, String defaultValue) {
        return U.or(this.params_().get(name), defaultValue);
    }

    @Override
    public synchronized Map<String, String> headers() {
        return this.headers_().get();
    }

    @Override
    public synchronized String header(String name) {
        return U.notNull(this.headers_().get(name), "HEADERS[%s]", name);
    }

    @Override
    public String header(String name, String defaultValue) {
        return U.or(this.headers_().get(name), defaultValue);
    }

    @Override
    public synchronized Map<String, String> cookies() {
        return this.cookies_().get();
    }

    @Override
    public synchronized String cookie(String name) {
        return U.notNull(this.cookies_().get(name), "COOKIES[%s]", name);
    }

    @Override
    public String cookie(String name, String defaultValue) {
        return U.or(this.cookies_().get(name), defaultValue);
    }

    @Override
    public synchronized Map<String, String> data() {
        return this.data_().get();
    }

    @Override
    public synchronized String data(String name) {
        return U.notNull(this.data_().get(name), "DATA[%s]", name);
    }

    @Override
    public String data(String name, String defaultValue) {
        return U.or(this.data_().get(name), defaultValue);
    }

    @Override
    public synchronized Map<String, byte[]> files() {
        return this.files_().get();
    }

    @Override
    public synchronized byte[] file(String name) {
        return U.notNull(this.files_().get(name), "FILE[%s]", name);
    }

    @Override
    public synchronized byte[] file(String name, byte[] defaultValue) {
        return U.or(this.files_().get(name), defaultValue);
    }

    @Override
    public synchronized Data host_() {
        return this.headers_().get_("host");
    }

    @Override
    public synchronized String host() {
        return this.headers_().get("host");
    }

    public synchronized void setResponses(HttpResponses responses) {
        this.responses = responses;
    }

    public synchronized void setSession(HttpSession session) {
        this.session = session;
    }

    @Override
    public synchronized HttpExchange addHeader(byte[] name, byte[] value) {
        if (this.responseCode <= 0) {
            this.responseCode(200);
        }
        super.write(name);
        super.write(HEADER_SEP);
        super.write(value);
        super.write(CR_LF);
        return this;
    }

    @Override
    public synchronized HttpExchangeHeaders responseCode(int responseCode) {
        if (this.responseCode > 0) {
            assert (this.startingPos >= 0);
            this.output().deleteAfter(this.startingPos);
        }
        this.responseCode = responseCode;
        this.startingPos = this.output().size();
        this.output().append(this.getResp(responseCode).bytes());
        this.hasContentType = false;
        this.writesBody = false;
        this.bodyPos = -1;
        return this;
    }

    public synchronized void completeResponse() {
        U.must(this.responseCode >= 100);
        U.must(this.bodyPos >= 0);
        long responseSize = this.output().size() - this.bodyPos;
        U.must(responseSize <= Integer.MAX_VALUE, "Response too big!");
        int pos = this.startingPos + this.getResp((int)this.responseCode).contentLengthPos + 10;
        this.output().putNumAsText(pos, responseSize, false);
        this.resetResponse();
    }

    private HttpResponse getResp(int code) {
        HttpResponse resp = this.responses.get(code, this.isKeepAlive.value);
        assert (resp != null);
        return resp;
    }

    @Override
    public synchronized HttpExchange addHeader(HttpHeader name, String value) {
        this.addHeader(name.getBytes(), value.getBytes());
        return this;
    }

    @Override
    public synchronized HttpExchange setCookie(String name, String value) {
        this.addHeader(HttpHeader.SET_COOKIE, name + "=" + value);
        return this;
    }

    @Override
    public synchronized HttpExchange setContentType(MediaType MediaType2) {
        U.must(!this.hasContentType, "Content type was already set!");
        this.addHeader(HttpHeader.CONTENT_TYPE.getBytes(), MediaType2.getBytes());
        this.hasContentType = true;
        return this;
    }

    @Override
    public synchronized HttpExchange plain() {
        return this.setContentType(MediaType.PLAIN_TEXT_UTF_8);
    }

    @Override
    public synchronized HttpExchange html() {
        return this.setContentType(MediaType.HTML_UTF_8);
    }

    @Override
    public synchronized HttpExchange json() {
        return this.setContentType(MediaType.JSON_UTF_8);
    }

    @Override
    public synchronized HttpExchange binary() {
        return this.setContentType(MediaType.BINARY);
    }

    @Override
    public synchronized HttpExchange download(String filename) {
        this.addHeader(HttpHeader.CONTENT_DISPOSITION, "attachment; filename=\"" + filename + "\"");
        this.addHeader(HttpHeader.CACHE_CONTROL, "private");
        return this.binary();
    }

    public synchronized void ensureHeadersComplete() {
        if (!this.writesBody) {
            if (!this.hasContentType) {
                this.html();
            }
            this.writesBody = true;
            this.write(CR_LF);
            this.bodyPos = this.output().size();
        }
    }

    @Override
    public synchronized HttpExchangeBody write(String s) {
        this.ensureHeadersComplete();
        return (HttpExchangeBody)super.write(s);
    }

    @Override
    public synchronized HttpExchangeBody writeln(String s) {
        this.ensureHeadersComplete();
        return (HttpExchangeBody)super.writeln(s);
    }

    @Override
    public synchronized HttpExchangeBody write(byte[] bytes) {
        this.ensureHeadersComplete();
        return (HttpExchangeBody)super.write(bytes);
    }

    @Override
    public synchronized HttpExchangeBody write(byte[] bytes, int offset, int length) {
        this.ensureHeadersComplete();
        return (HttpExchangeBody)super.write(bytes, offset, length);
    }

    @Override
    public synchronized HttpExchangeBody write(ByteBuffer buf) {
        this.ensureHeadersComplete();
        return (HttpExchangeBody)super.write(buf);
    }

    @Override
    public synchronized HttpExchangeBody write(File file) {
        if (!this.hasContentType()) {
            this.download(file.getName());
        }
        this.ensureHeadersComplete();
        return (HttpExchangeBody)super.write(file);
    }

    @Override
    public synchronized HttpExchangeBody writeJSON(Object value) {
        if (!this.hasContentType()) {
            this.json();
        }
        this.ensureHeadersComplete();
        return (HttpExchangeBody)super.writeJSON(value);
    }

    @Override
    public synchronized boolean isInitial() {
        return this.conn.isInitial();
    }

    @Override
    public synchronized ConnState state() {
        return this.conn.state();
    }

    public synchronized boolean hasContentType() {
        return this.hasContentType;
    }

    @Override
    public synchronized HttpExchangeBody sendFile(File file) {
        U.must(file.exists());
        this.setContentType(MediaType.getByFileName(file.getAbsolutePath()));
        this.write(file);
        return this;
    }

    @Override
    public synchronized HttpExchangeBody redirect(String url) {
        this.responseCode(303);
        this.addHeader(HttpHeader.LOCATION, url);
        this.ensureHeadersComplete();
        return this;
    }

    @Override
    public synchronized HttpExchangeHeaders response(int httpResponseCode) {
        return this.response(httpResponseCode, null, null);
    }

    @Override
    public synchronized HttpExchangeHeaders response(int httpResponseCode, String response) {
        return this.response(httpResponseCode, response, null);
    }

    @Override
    public synchronized HttpExchangeHeaders response(int httpResponseCode, String response, Throwable err) {
        this.responseCode(httpResponseCode);
        this.ensureHeadersComplete();
        if (U.production()) {
            if (response != null) {
                this.write(response);
            }
        } else {
            String title = U.or(response, "Error occured!");
            if (err != null) {
                if (this.devMode()) {
                    HTMLSnippets.writeErrorPage(this, title, err);
                } else {
                    HTMLSnippets.writeFullPage(this, title, "");
                }
            } else {
                HTMLSnippets.writeFullPage(this, title, "<h1>The requested page cannot be found!</h1>");
            }
        }
        return this;
    }

    @Override
    public synchronized String constructUrl(String path) {
        return (U.hasOption("https") ? "https://" : "http://") + this.host() + path;
    }

    @Override
    public synchronized String sessionId() {
        if (this.sessionId == null) {
            this.sessionId = this.cookie(SESSION_COOKIE, null);
            if (this.sessionId != null && !this.session.exists(this.sessionId)) {
                this.sessionId = null;
            }
            if (this.sessionId == null) {
                this.sessionId = U.rndStr(50);
                this.setCookie(SESSION_COOKIE, this.sessionId);
                this.session.openSession(this.sessionId);
            }
        }
        return this.sessionId;
    }

    @Override
    public synchronized Map<String, Object> session() {
        return this.session.getSession(this.sessionId());
    }

    @Override
    public synchronized HttpExchangeHeaders sessionSet(String name, Object value) {
        if (value != null) {
            this.session.setAttribute(this.sessionId(), name, value);
        } else {
            this.session.deleteAttribute(this.sessionId(), name);
        }
        return this;
    }

    @Override
    public synchronized <T> T session(String name, T defaultValue) {
        return (T)U.or(this.session.getAttribute(this.sessionId(), name), defaultValue);
    }

    @Override
    public synchronized <T> T session(String name) {
        Object value = this.session.getAttribute(this.sessionId(), name);
        U.notNull(value, "session[" + name + "]", new Object[0]);
        return (T)value;
    }

    @Override
    public synchronized <T> T sessionGetOrCreate(String name, Class<T> valueClass, Object ... constructorArgs) {
        Object value = this.session.getAttribute(this.sessionId(), name);
        if (value == null) {
            value = U.newInstance(valueClass, constructorArgs);
            this.session.setAttribute(this.sessionId(), name, value);
        }
        return (T)value;
    }

    @Override
    public synchronized HttpExchangeHeaders closeSession() {
        this.session.closeSession(this.sessionId());
        this.sessionId = null;
        return this;
    }

    @Override
    public synchronized boolean hasSession() {
        return this.session != null;
    }

    @Override
    public synchronized HttpExchangeHeaders notFound() {
        return this.response(404, "Error: page not found!");
    }

    @Override
    public synchronized boolean isLoggedIn() {
        return this.hasSession() && this.session(SESSION_USER, null) != null;
    }

    @Override
    public synchronized UserInfo user() {
        U.must(this.isLoggedIn(), "Must be logged in!");
        return (UserInfo)this.session(SESSION_USER);
    }

    @Override
    public synchronized boolean isGetReq() {
        return this.isGet.value;
    }

    @Override
    public synchronized byte[] sessionSerialize() {
        return UTILS.serialize(this.session);
    }

    @Override
    public synchronized void sessionDeserialize(byte[] bytes) {
        this.session = (HttpSession)UTILS.deserialize(bytes);
    }

    @Override
    public synchronized OutputStream outputStream() {
        return new HttpOutputStream(this);
    }

    @Override
    public synchronized boolean devMode() {
        String host = this.host();
        return host == null || host.equals("localhost") || host.equals("127.0.0.1") || host.startsWith("localhost:") || host.startsWith("127.0.0.1:");
    }
}

