/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import org.rapidoid.buffer.Buf;
import org.rapidoid.bytes.BYTES;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.data.KeyValueRanges;
import org.rapidoid.data.Range;
import org.rapidoid.data.Ranges;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.util.Constants;
import org.rapidoid.util.U;
import org.rapidoid.wrap.Bool;
import org.rapidoid.wrap.Int;

public class HttpParser
implements Constants {
    private static final byte[] CONNECTION = "Connection:".getBytes();
    private static final byte[] KEEP_ALIVE = "keep-alive".getBytes();
    private static final byte[] CONTENT_LENGTH = "Content-Length:".getBytes();
    private static final byte[] COOKIE = "Cookie".getBytes();
    private static final byte[] MULTIPART_FORM_DATA_BOUNDARY1 = "multipart/form-data; boundary=".getBytes();
    private static final byte[] MULTIPART_FORM_DATA_BOUNDARY2 = "multipart/form-data;boundary=".getBytes();
    private static final byte[] CONTENT_TYPE = "Content-Type".getBytes();
    private static final byte[] CONTENT_DISPOSITION = "Content-Disposition".getBytes();
    private static final byte[] FORM_DATA = "form-data;".getBytes();
    private static final byte[] NAME_EQ = "name=".getBytes();
    private static final byte[] FILENAME_EQ = "filename=".getBytes();
    private static final byte[] CHARSET_EQ = "charset=".getBytes();
    private static final byte[] _UTF_8 = "UTF-8".getBytes();
    private static final byte[] CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding".getBytes();
    private static final byte[] _7BIT = "7bit".getBytes();
    private static final byte[] _8BIT = "8bit".getBytes();
    private static final byte[] BINARY = "binary".getBytes();
    private static final byte[] GET = "GET".getBytes();

    public void parse(Buf buf, Bool isGet, Bool isKeepAlive, Range body, Range verb, Range uri, Range path, Range query, Range protocol, Ranges headers, RapidoidHelper helper) {
        Bytes bytes = buf.bytes();
        buf.scanUntil((byte)32, verb);
        buf.scanUntil((byte)32, uri);
        buf.scanLn(protocol);
        Int result = helper.integers[0];
        buf.scanLnLn(headers.reset(), result, (byte)115, (byte)101);
        int possibleClosePos = result.value;
        isKeepAlive.value = possibleClosePos < 0 ? true : this.isKeepAlive(bytes, headers, helper);
        BYTES.split(bytes, uri, (byte)63, path, query, false);
        if (BYTES.matches(bytes, verb, GET, true)) {
            isGet.value = true;
        } else {
            isGet.value = false;
            this.parseBody(buf, body, headers, helper);
        }
    }

    public void parse2(Buf buf, Bool isGet, Bool isKeepAlive, Range body, Range verb, Range uri, Range path, Range query, Range protocol, Ranges headers, RapidoidHelper helper) {
        Bytes bytes = buf.bytes();
        buf.scanUntil((byte)32, verb);
        buf.scanUntil((byte)32, uri);
        buf.scanLn(protocol);
        Int result = helper.integers[0];
        int nextPos = BYTES.parseLines(bytes, headers.reset(), result, buf.position(), buf.limit(), (byte)115, (byte)101);
        if (nextPos < 0) {
            throw Buf.INCOMPLETE_READ;
        }
        buf.position(nextPos);
        int possibleClosePos = result.value;
        isKeepAlive.value = possibleClosePos < 0 ? true : this.isKeepAlive(bytes, headers, helper);
        BYTES.split(bytes, uri, (byte)63, path, query, false);
        if (BYTES.matches(bytes, verb, GET, true)) {
            isGet.value = true;
        } else {
            isGet.value = false;
            this.parseBody(buf, body, headers, helper);
        }
    }

    private boolean isKeepAlive(Bytes bytes, Ranges headers, RapidoidHelper helper) {
        Range connHdr = headers.getByPrefix(bytes, CONNECTION, false);
        return connHdr != null ? this.getKeepAliveValue(bytes, connHdr, helper) : true;
    }

    private boolean getKeepAliveValue(Bytes bytes, Range connHdr, RapidoidHelper helper) {
        assert (bytes != null);
        assert (connHdr != null);
        Range connVal = helper.ranges5.ranges[3];
        connVal.setInterval(connHdr.start + CONNECTION.length, connHdr.limit());
        BYTES.trim(bytes, connVal);
        return BYTES.matches(bytes, connVal, KEEP_ALIVE, false);
    }

    private void parseBody(Buf buf, Range body, Ranges headers, RapidoidHelper helper) {
        Range clen = headers.getByPrefix(buf.bytes(), CONTENT_LENGTH, false);
        if (clen != null) {
            Range clenValue = helper.ranges5.ranges[helper.ranges5.ranges.length - 1];
            clenValue.setInterval(clen.start + CONTENT_LENGTH.length, clen.limit());
            BYTES.trim(buf.bytes(), clenValue);
            long len = buf.getN(clenValue);
            U.must(len >= 0L && len <= Integer.MAX_VALUE, "Invalid body size!");
            buf.scanN((int)len, body);
            U.debug("Request body complete", "range", body);
        }
    }

    public void parseParams(Buf buf, KeyValueRanges params, Range range) {
        this.parseURLEncodedKV(buf, params, range);
    }

    private void parseURLEncodedKV(Buf buf, KeyValueRanges params, Range range) {
        int pos = buf.position();
        int limit = buf.limit();
        buf.position(range.start);
        buf.limit(range.limit());
        while (buf.hasRemaining()) {
            int ind = params.add();
            int which = buf.scanTo((byte)61, (byte)38, params.keys[ind], false);
            if (which != 1) continue;
            buf.scanTo((byte)38, params.values[ind], false);
        }
        buf.position(pos);
        buf.limit(limit);
    }

    public int parseHeaders(Buf buf, int from, int to, KeyValueRanges headersKV, RapidoidHelper helper) {
        int pos = buf.position();
        int limit = buf.limit();
        buf.position(from);
        buf.limit(to);
        Ranges headers = helper.ranges2.reset();
        buf.scanLnLn(headers);
        this.parseHeadersIntoKV(buf, headers, headersKV, null, helper);
        int bodyPos = buf.position();
        buf.position(pos);
        buf.limit(limit);
        return bodyPos;
    }

    public void parseHeadersIntoKV(Buf buf, Ranges headers, KeyValueRanges headersKV, KeyValueRanges cookies, RapidoidHelper helper) {
        Range cookie = helper.ranges5.ranges[0];
        for (int i = 0; i < headers.count; ++i) {
            Range hdr = headers.ranges[i];
            int ind = headersKV.add();
            Range key = headersKV.keys[ind];
            Range val = headersKV.values[ind];
            assert (!hdr.isEmpty());
            boolean split = BYTES.split(buf.bytes(), hdr, (byte)58, key, val, true);
            U.must(split, "Invalid HTTP header!");
            if (cookies == null || !BYTES.matches(buf.bytes(), key, COOKIE, false)) continue;
            --headersKV.count;
            do {
                BYTES.split(buf.bytes(), val, (byte)59, cookie, val, true);
                int cind = cookies.add();
                BYTES.split(buf.bytes(), cookie, (byte)61, cookies.keys[cind], cookies.values[cind], true);
            } while (!val.isEmpty());
        }
    }

    public void parseBody(Buf src, KeyValueRanges headers, Range body, KeyValueRanges data, KeyValueRanges files, RapidoidHelper helper) {
        Range multipartBoundary = helper.ranges5.ranges[0];
        if (this.isMultipartForm(src, headers, multipartBoundary)) {
            helper.bytes[0] = 45;
            helper.bytes[1] = 45;
            src.get(multipartBoundary, helper.bytes, 2);
            U.failIf(multipartBoundary.isEmpty(), "Invalid multi-part HTTP request!");
            this.parseMultiParts(src, body, data, files, multipartBoundary, helper);
        } else {
            this.parseURLEncodedKV(src, data, body);
        }
    }

    private void parseMultiParts(Buf src, Range body, KeyValueRanges data, KeyValueRanges files, Range multipartBoundary, RapidoidHelper helper) {
        int start = body.start;
        int limit = body.limit();
        int sepLen = multipartBoundary.length + 2;
        int pos1 = -1;
        try {
            int pos2;
            while ((pos2 = BYTES.find(src.bytes(), start, limit, helper.bytes, 0, sepLen, true)) >= 0) {
                if (pos1 >= 0 && pos2 >= 0) {
                    int from = pos1 + sepLen + 2;
                    int to = pos2 - 2;
                    this.parseMultiPart(src, body, data, files, multipartBoundary, helper, from, to);
                }
                pos1 = pos2;
                start = pos2 + sepLen;
            }
        }
        catch (Throwable e) {
            U.warn("Multipart parse error!", e);
            throw U.rte("Multipart data parse error!");
        }
    }

    private void parseMultiPart(Buf src, Range body, KeyValueRanges data, KeyValueRanges files, Range multipartBoundary, RapidoidHelper helper, int from, int to) {
        int ind;
        Range encoding;
        KeyValueRanges headers = helper.pairs;
        Range partBody = helper.ranges4.ranges[0];
        Range contType = helper.ranges4.ranges[1];
        Range contEnc = helper.ranges4.ranges[2];
        Range dispo1 = helper.ranges4.ranges[3];
        Range dispo2 = helper.ranges4.ranges[4];
        Range name = helper.ranges4.ranges[5];
        Range filename = helper.ranges4.ranges[6];
        Range charset = helper.ranges4.ranges[7];
        headers.reset();
        int bodyPos = this.parseHeaders(src, from, to, headers, helper);
        partBody.setInterval(bodyPos, to);
        Range disposition = headers.get(src, CONTENT_DISPOSITION, false);
        if (!BYTES.startsWith(src.bytes(), disposition, FORM_DATA, false)) {
            return;
        }
        disposition.strip(FORM_DATA.length, 0);
        BYTES.split(src.bytes(), disposition, (byte)59, dispo1, dispo2, true);
        if (!this.parseDisposition(src, dispo1, dispo2, name, filename) && !this.parseDisposition(src, dispo2, dispo1, name, filename)) {
            throw U.rte("Unrecognized Content-disposition header!");
        }
        Range contentType = headers.get(src, CONTENT_TYPE, false);
        charset.reset();
        contType.reset();
        contEnc.reset();
        if (contentType != null) {
            BYTES.split(src.bytes(), contentType, (byte)59, contType, contEnc, true);
            if (BYTES.startsWith(src.bytes(), contEnc, CHARSET_EQ, false)) {
                charset.assign(contEnc);
                charset.strip(CHARSET_EQ.length, 0);
                BYTES.trim(src.bytes(), charset);
                U.failIf(!BYTES.matches(src.bytes(), charset, _UTF_8, false), "Only the UTF-8 charset is supported!");
            }
        }
        if ((encoding = headers.get(src, CONTENT_TRANSFER_ENCODING, false)) != null) {
            boolean validEncoding = BYTES.matches(src.bytes(), encoding, _7BIT, false) || BYTES.matches(src.bytes(), encoding, _8BIT, false) || BYTES.matches(src.bytes(), encoding, BINARY, false);
            U.failIf(!validEncoding, "Invalid Content-transfer-encoding header value!");
        }
        if (filename.isEmpty()) {
            ind = data.add();
            data.keys[ind].assign(name);
            data.values[ind].assign(partBody);
        } else {
            ind = files.add();
            files.keys[ind].assign(name);
            files.values[ind].assign(partBody);
        }
    }

    private boolean parseDisposition(Buf src, Range dispoA, Range dispoB, Range name, Range filename) {
        if (BYTES.startsWith(src.bytes(), dispoA, NAME_EQ, false)) {
            name.assign(dispoA);
            name.strip(NAME_EQ.length, 0);
            BYTES.trim(src.bytes(), name);
            name.strip(1, 1);
            if (BYTES.startsWith(src.bytes(), dispoB, FILENAME_EQ, false)) {
                filename.assign(dispoB);
                filename.strip(FILENAME_EQ.length, 0);
                BYTES.trim(src.bytes(), filename);
                filename.strip(1, 1);
            } else {
                filename.reset();
            }
            return true;
        }
        return false;
    }

    private boolean isMultipartForm(Buf buf, KeyValueRanges headers, Range multipartBoundary) {
        Range contType = headers.get(buf, CONTENT_TYPE, false);
        if (contType != null) {
            if (BYTES.startsWith(buf.bytes(), contType, MULTIPART_FORM_DATA_BOUNDARY1, false)) {
                multipartBoundary.setInterval(contType.start + MULTIPART_FORM_DATA_BOUNDARY1.length, contType.limit());
                return true;
            }
            if (BYTES.startsWith(buf.bytes(), contType, MULTIPART_FORM_DATA_BOUNDARY2, false)) {
                multipartBoundary.setInterval(contType.start + MULTIPART_FORM_DATA_BOUNDARY2.length, contType.limit());
                return true;
            }
        }
        multipartBoundary.reset();
        return false;
    }
}

