/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import org.rapidoid.http.HttpExchangeImpl;
import org.rapidoid.http.HttpParser;
import org.rapidoid.http.HttpResponses;
import org.rapidoid.http.HttpSession;
import org.rapidoid.http.Router;
import org.rapidoid.inject.IoC;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.net.impl.ExchangeProtocol;
import org.rapidoid.util.U;

public class HttpProtocol
extends ExchangeProtocol<HttpExchangeImpl> {
    private final HttpParser parser = IoC.singleton(HttpParser.class);
    private final Router router;
    private final HttpResponses responses;
    private HttpSession session;

    public HttpProtocol(Router router) {
        super(HttpExchangeImpl.class);
        this.router = router;
        this.responses = new HttpResponses(true, true);
    }

    @Override
    protected void process(Channel ctx, HttpExchangeImpl x) {
        U.notNull(this.session, "session", new Object[0]);
        if (ctx.isInitial()) {
            return;
        }
        this.parser.parse(x.input(), x.isGet, x.isKeepAlive, x.body, x.verb, x.uri, x.path, x.query, x.protocol, x.headers, x.helper());
        U.failIf(x.verb.isEmpty() || x.uri.isEmpty(), "Invalid HTTP request!");
        U.failIf(x.isGet.value && !x.body.isEmpty(), "Body is NOT allowed in HTTP GET requests!");
        x.setResponses(this.responses);
        x.setSession(this.session);
        try {
            boolean dispatched = this.router.dispatch(x);
            if (!dispatched) {
                x.notFound();
            }
        }
        catch (Throwable e) {
            U.error("Internal server error!", "request", x, "error", e);
            x.response(500, "Internal server error!", e);
        }
        if (!x.hasContentType()) {
            x.html();
        }
        x.completeResponse();
        x.closeIf(!x.isKeepAlive.value);
    }

    public Router getRouter() {
        return this.router;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }
}

