/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.rapidoid.http.HttpSession;
import org.rapidoid.util.U;

public class InMemoryHttpSession
implements HttpSession {
    private static final long serialVersionUID = -3390334080583841460L;
    private final ConcurrentMap<String, ConcurrentMap<String, Object>> sessions = U.concurrentMap();

    @Override
    public void openSession(String sessionId) {
        ConcurrentMap prev = this.sessions.putIfAbsent(sessionId, U.concurrentMap());
        U.must(prev == null, "There is already an existing session with ID=%s", sessionId);
    }

    @Override
    public Map<String, Object> getSession(String sessionId) {
        return Collections.unmodifiableMap(this.session(sessionId));
    }

    @Override
    public void setAttribute(String sessionId, String attribute, Object value) {
        this.session(sessionId).put(attribute, value);
    }

    @Override
    public Object getAttribute(String sessionId, String attribute) {
        return this.session(sessionId).get(attribute);
    }

    @Override
    public void deleteAttribute(String sessionId, String attribute) {
        this.session(sessionId).remove(attribute);
    }

    @Override
    public void closeSession(String sessionId) {
        this.sessions.remove(sessionId);
    }

    @Override
    public boolean exists(String sessionId) {
        return this.sessions.containsKey(sessionId);
    }

    private ConcurrentMap<String, Object> session(String sessionId) {
        ConcurrentMap session = (ConcurrentMap)this.sessions.get(sessionId);
        U.must(session != null, "Cannot find session with ID=%s", sessionId);
        return session;
    }
}

