/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.inject;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rapidoid.annotation.Autocreate;
import org.rapidoid.annotation.Init;
import org.rapidoid.annotation.Inject;
import org.rapidoid.annotation.Session;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.util.Builder;
import org.rapidoid.util.Cls;
import org.rapidoid.util.F3;
import org.rapidoid.util.U;

public class IoC {
    private static final Map<Class<?>, Object> SINGLETONS = U.map();
    private static final Set<Class<?>> MANAGED_CLASSES = U.set(new Object[0]);
    private static final Set<Object> MANAGED_INSTANCES = U.set(new Object[0]);
    private static final Map<Object, Object> IOC_INSTANCES = U.map();
    private static final Map<Class<?>, List<Field>> INJECTABLE_FIELDS = U.autoExpandingMap(new Mapper<Class<?>, List<Field>>(){

        @Override
        public List<Field> map(Class<?> clazz) throws Exception {
            List<Field> fields = Cls.getFieldsAnnotated(clazz, Inject.class);
            U.debug("Retrieved injectable fields", "class", clazz, "fields", fields);
            return fields;
        }
    });
    private static final Map<Class<?>, List<Field>> SESSION_FIELDS = U.autoExpandingMap(new Mapper<Class<?>, List<Field>>(){

        @Override
        public List<Field> map(Class<?> clazz) throws Exception {
            List<Field> fields = Cls.getFieldsAnnotated(clazz, Session.class);
            U.debug("Retrieved session fields", "class", clazz, "fields", fields);
            return fields;
        }
    });
    private static final Map<Class<?>, Set<Object>> INJECTION_PROVIDERS = U.map();
    private static final Map<Class<?>, List<F3<Object, Object, Method, Object[]>>> INTERCEPTORS = U.map();

    public static synchronized void reset() {
        U.info("Reseting IoC state");
        U.setLogLevel(U.INFO);
        U.args(new String[0]);
        Cls.reset();
        SINGLETONS.clear();
        MANAGED_CLASSES.clear();
        MANAGED_INSTANCES.clear();
        IOC_INSTANCES.clear();
        INJECTABLE_FIELDS.clear();
        SESSION_FIELDS.clear();
        INJECTION_PROVIDERS.clear();
        INTERCEPTORS.clear();
    }

    public static <K, V> Map<K, V> autoExpandingInjectingMap(final Class<V> clazz) {
        return U.autoExpandingMap(new Mapper<K, V>(){

            @Override
            public V map(K src) throws Exception {
                return IoC.inject(U.newInstance(clazz));
            }
        });
    }

    public static synchronized void manage(Object ... classesOrInstances) {
        ArrayList autocreate = new ArrayList();
        for (Object classOrInstance : classesOrInstances) {
            boolean isClass = IoC.isClass(classOrInstance);
            Class<?> clazz = isClass ? (Class<?>)classOrInstance : classOrInstance.getClass();
            for (Class<?> interfacee : Cls.getImplementedInterfaces(clazz)) {
                IoC.addInjectionProvider(interfacee, classOrInstance);
            }
            if (isClass) {
                U.debug("configuring managed class", "class", classOrInstance);
                MANAGED_CLASSES.add(clazz);
                if (clazz.isInterface() || clazz.isEnum() || clazz.isAnnotation() || clazz.getAnnotation(Autocreate.class) == null) continue;
                autocreate.add(clazz);
                continue;
            }
            U.debug("configuring managed instance", "instance", classOrInstance);
            IoC.addInjectionProvider(clazz, classOrInstance);
            MANAGED_INSTANCES.add(classOrInstance);
        }
        for (Class clazz : autocreate) {
            IoC.singleton(clazz);
        }
    }

    private static void addInjectionProvider(Class<?> type, Object provider) {
        Set<Object> providers = INJECTION_PROVIDERS.get(type);
        if (providers == null) {
            providers = U.set(new Object[0]);
            INJECTION_PROVIDERS.put(type, providers);
        }
        providers.add(provider);
    }

    public static synchronized <T> T singleton(Class<T> type) {
        U.debug("Inject", "type", type);
        return IoC.provideIoCInstanceOf(null, type, null, null, false);
    }

    public static synchronized <T> T autowire(T target) {
        U.debug("Autowire", "target", target);
        IoC.autowire(target, null, null);
        return target;
    }

    public static synchronized <T> T autowire(T target, Mapper<String, Object> session) {
        U.debug("Autowire", "target", target);
        IoC.autowire(target, null, session);
        return target;
    }

    public static synchronized <T> T inject(T target) {
        U.debug("Inject", "target", target);
        return IoC.ioc(target, null);
    }

    public static synchronized <T> T inject(T target, Map<String, Object> properties) {
        U.debug("Inject", "target", target, "properties", properties);
        return IoC.ioc(target, properties);
    }

    private static <T> T provideSessionValue(Object target, Class<T> type, String name, Mapper<String, Object> session) {
        U.notNull(session, "session", new Object[0]);
        Object value = U.eval(session, name);
        return value != null ? (T)Cls.convert(value, type) : null;
    }

    private static <T> T provideIoCInstanceOf(Object target, Class<T> type, String name, Map<String, Object> properties, boolean optional) {
        T instance = null;
        if (name != null) {
            instance = IoC.provideInstanceByName(target, type, name, properties);
        }
        if (instance == null) {
            instance = IoC.provideIoCInstanceByType(type, properties);
        }
        if (instance == null && IoC.canInjectNew(type)) {
            instance = IoC.provideNewIoCInstanceOf(type, properties);
        }
        if (!optional && instance == null) {
            if (name != null) {
                throw U.rte("Didn't find a value for type '%s' and name '%s'!", type, name);
            }
            throw U.rte("Didn't find a value for type '%s'!", type);
        }
        return instance != null ? IoC.ioc(instance, properties) : null;
    }

    private static boolean canInjectNew(Class<?> type) {
        return !type.isAnnotation() && !type.isEnum() && !type.isInterface() && !type.isPrimitive() && !type.equals(String.class) && !type.equals(Object.class) && !type.equals(Boolean.class) && !Number.class.isAssignableFrom(type);
    }

    private static <T> T provideNewIoCInstanceOf(Class<T> type, Map<String, Object> properties) {
        if (!(type.isInterface() || type.isEnum() || type.isAnnotation())) {
            Object instance = SINGLETONS.get(type);
            if (instance == null) {
                instance = IoC.ioc(Cls.newInstance(type, properties), properties);
            }
            return (T)instance;
        }
        return null;
    }

    private static <T> T provideIoCInstanceByType(Class<T> type, Map<String, Object> properties) {
        Set<Object> providers = INJECTION_PROVIDERS.get(type);
        if (providers != null && !providers.isEmpty()) {
            Object provider = null;
            for (Object pr : providers) {
                if (provider == null) {
                    provider = pr;
                    continue;
                }
                if (IoC.isClass(provider) && !IoC.isClass(pr)) {
                    provider = pr;
                    continue;
                }
                if (!IoC.isClass(provider) && IoC.isClass(pr)) continue;
                throw U.rte("Found more than 1 injection candidates for type '%s': %s", type, providers);
            }
            if (provider != null) {
                return IoC.provideFrom(provider, properties);
            }
        }
        return null;
    }

    private static <T> T provideFrom(Object classOrInstance, Map<String, Object> properties) {
        Object instance = IoC.isClass(classOrInstance) ? IoC.provideNewIoCInstanceOf((Class)classOrInstance, properties) : classOrInstance;
        return (T)instance;
    }

    private static boolean isClass(Object obj) {
        return obj instanceof Class;
    }

    private static <T> T provideInstanceByName(Object target, Class<T> type, String name, Map<String, Object> properties) {
        T instance = IoC.getInjectableByName(type, name, properties, false);
        if (target != null) {
            instance = IoC.getInjectableByName(type, target.getClass().getSimpleName() + "." + name, properties, true);
        }
        if (instance == null) {
            instance = IoC.getInjectableByName(type, name, properties, true);
        }
        return instance;
    }

    private static <T> T getInjectableByName(Class<T> type, String name, Map<String, Object> properties, boolean useConfig) {
        Object instance;
        Object object = instance = properties != null ? properties.get(name) : null;
        if (instance == null && useConfig) {
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                instance = U.hasOption(name);
            } else {
                String opt = U.option(name, null);
                if (opt != null) {
                    instance = Cls.convert(opt, type);
                }
            }
        }
        return (T)instance;
    }

    private static void autowire(Object target, Map<String, Object> properties, Mapper<String, Object> session) {
        U.debug("Autowiring", "target", target);
        for (Field field : INJECTABLE_FIELDS.get(target.getClass())) {
            boolean optional = IoC.isInjectOptional(field);
            Object value = IoC.provideIoCInstanceOf(target, field.getType(), field.getName(), properties, optional);
            U.debug("Injecting field value", "target", target, "field", field.getName(), "value", value);
            if (optional && value == null) continue;
            Cls.setFieldValue(target, field.getName(), value);
        }
        for (Field field : SESSION_FIELDS.get(target.getClass())) {
            Object value = IoC.provideSessionValue(target, field.getType(), field.getName(), session);
            if (value == null) continue;
            U.debug("Injecting session field value", "target", target, "field", field.getName(), "value", value);
            Cls.setFieldValue(target, field.getName(), value);
        }
    }

    private static boolean isInjectOptional(Field field) {
        Inject inject = field.getAnnotation(Inject.class);
        return inject != null && inject.optional();
    }

    private static <T> void invokePostConstruct(T target) {
        List<Method> methods = Cls.getMethodsAnnotated(target.getClass(), Init.class);
        for (Method method : methods) {
            Cls.invoke(method, target, new Object[0]);
        }
    }

    private static <T> T ioc(T target, Map<String, Object> properties) {
        if (!IoC.isIocProcessed(target)) {
            IOC_INSTANCES.put(target, null);
            IoC.manage(target);
            IoC.autowire(target, properties, null);
            IoC.invokePostConstruct(target);
            T proxy = IoC.proxyWrap(target);
            IOC_INSTANCES.put(target, proxy);
            IoC.manage(proxy);
            target = proxy;
        }
        return target;
    }

    private static boolean isIocProcessed(Object target) {
        for (Map.Entry<Object, Object> e : IOC_INSTANCES.entrySet()) {
            if (e.getKey() != target && e.getValue() != target) continue;
            return true;
        }
        return false;
    }

    private static <T> T proxyWrap(T instance) {
        Set<Object> done = U.set(new Object[0]);
        for (Class<?> interf : Cls.getImplementedInterfaces(instance.getClass())) {
            List<F3<Object, Object, Method, Object[]>> interceptors = INTERCEPTORS.get(interf);
            if (interceptors == null) continue;
            for (final F3<Object, Object, Method, Object[]> interceptor : interceptors) {
                if (interceptor == null || done.contains(interceptor)) continue;
                U.debug("Creating proxy", "target", instance, "interface", interf, "interceptor", interceptor);
                final T target = instance;
                InvocationHandler handler = new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        return interceptor.execute(target, method, args);
                    }
                };
                instance = Cls.implement(instance, handler, interf);
                done.add(interceptor);
            }
        }
        return instance;
    }

    public static <T, B extends Builder<T>> B builder(Class<B> builderClass, Class<T> builtClass, final Class<? extends T> implClass) {
        final Map properties = U.map();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().equals(Builder.class)) {
                    return IoC.inject(Cls.newInstance(implClass, properties), properties);
                }
                U.must(args.length == 1, "expected 1 argument!");
                properties.put(method.getName(), args[0]);
                return proxy;
            }
        };
        Builder builder = (Builder)Cls.implement(handler, builderClass);
        return (B)builder;
    }

    public static synchronized List<Field> getSessionFields(Object target) {
        return SESSION_FIELDS.get(target.getClass());
    }
}

