/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.inmem;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.rapidoid.inmem.Rec;
import org.rapidoid.json.JSON;
import org.rapidoid.lambda.Operation;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.util.U;

public class InMem {
    private static final String SUFFIX_B = "b";
    private static final String SUFFIX_A = "a";
    private static final byte[] CR_LF = new byte[]{13, 10};
    private static final Object INSERTION = new Object();
    private final String filename;
    private final AtomicLong ids = new AtomicLong();
    private final AtomicBoolean active = new AtomicBoolean(true);
    private final AtomicBoolean aOrB = new AtomicBoolean(true);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Thread persistor;
    private final AtomicBoolean insideTx = new AtomicBoolean(false);
    private final ConcurrentNavigableMap<Long, Rec> txChanges = new ConcurrentSkipListMap<Long, Rec>();
    private final ConcurrentNavigableMap<Long, Object> txInsertions = new ConcurrentSkipListMap<Long, Object>();
    private ConcurrentNavigableMap<Long, Rec> prevData = new ConcurrentSkipListMap<Long, Rec>();
    private ConcurrentNavigableMap<Long, Rec> data = new ConcurrentSkipListMap<Long, Rec>();

    public InMem() {
        this(null);
    }

    public InMem(String filename) {
        this.filename = filename;
        if (filename != null && !filename.isEmpty()) {
            if (this.currentFile().exists() && this.otherFile().exists()) {
                throw new IllegalStateException(String.format("The database was left in inconsistent state, both %s and %s files exist! Please delete one of them!", this.currentFile().getName(), this.otherFile().getName()));
            }
            this.load();
            this.persistor = new Thread(new Runnable(){

                @Override
                public void run() {
                    InMem.this.persist();
                }
            });
            this.persistor.start();
        } else {
            this.persistor = null;
        }
    }

    private void load() {
        try {
            if (this.currentFile().exists()) {
                this.load(new FileInputStream(this.currentFile()));
                this.aOrB.set(false);
            } else if (this.otherFile().exists()) {
                this.load(new FileInputStream(this.otherFile()));
                this.aOrB.set(true);
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(Object record) {
        this.sharedLock();
        try {
            long id = this.ids.incrementAndGet();
            InMem.setId(record, id);
            if (this.insideTx.get() && this.txInsertions.putIfAbsent(id, INSERTION) != null) {
                throw new IllegalStateException("Cannot insert changelog record with existing ID: " + id);
            }
            if (this.data.putIfAbsent(id, InMem.rec(record, id)) != null) {
                throw new IllegalStateException("Cannot insert record with existing ID: " + id);
            }
            long l = id;
            return l;
        }
        finally {
            this.sharedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(long id) {
        this.sharedLock();
        try {
            this.validateId(id);
            Rec removed = (Rec)this.data.remove(id);
            if (this.insideTx.get()) {
                this.txChanges.putIfAbsent(id, removed);
            }
        }
        finally {
            this.sharedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E get(long id) {
        this.sharedLock();
        try {
            this.validateId(id);
            Rec rec = (Rec)this.data.get(id);
            E e = rec != null ? (E)InMem.setId(InMem.obj(rec), id) : null;
            return e;
        }
        finally {
            this.sharedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E get(long id, Class<E> clazz) {
        this.sharedLock();
        try {
            this.validateId(id);
            E e = this.get_(id, clazz);
            return e;
        }
        finally {
            this.sharedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long id, Object record) {
        this.sharedLock();
        try {
            this.validateId(id);
            InMem.setId(record, id);
            Rec removed = this.data.replace(id, InMem.rec(record, id));
            if (this.insideTx.get()) {
                this.txChanges.putIfAbsent(id, removed);
            }
            if (removed == null) {
                throw new IllegalStateException("Cannot update non-existing record with ID=" + id);
            }
        }
        finally {
            this.sharedUnlock();
        }
    }

    public void update(Object record) {
        this.update(InMem.getObjId(record), record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(long id, String column) {
        this.sharedLock();
        try {
            this.validateId(id);
            Map map = this.get_(id, Map.class);
            T t = map != null ? (T)map.get(column) : null;
            return t;
        }
        finally {
            this.sharedUnlock();
        }
    }

    public <E> List<E> getAll(final Class<E> clazz) {
        return this.find(new Predicate<E>(){

            @Override
            public boolean eval(E record) throws Exception {
                return clazz.isAssignableFrom(record.getClass());
            }
        });
    }

    public <E> List<E> find(final Predicate<E> match) {
        final ArrayList results = new ArrayList();
        this.each(new Operation<E>(){

            @Override
            public void execute(E record) throws Exception {
                if (match.eval(record)) {
                    results.add(record);
                }
            }
        });
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <E> void each(Operation<E> lambda) {
        this.sharedLock();
        try {
            for (Map.Entry entry : this.data.entrySet()) {
                Object record = InMem.obj((Rec)entry.getValue());
                InMem.setId(record, (Long)entry.getKey());
                try {
                    lambda.execute(record);
                }
                catch (ClassCastException e) {
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        finally {
            this.sharedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transaction(Runnable transaction) {
        this.globalLock();
        this.txChanges.clear();
        this.txInsertions.clear();
        this.insideTx.set(true);
        try {
            transaction.run();
        }
        catch (Throwable e) {
            U.debug("Error in transaction, rolling back", "error", e);
            this.txRollback();
        }
        finally {
            this.txChanges.clear();
            this.txInsertions.clear();
            this.insideTx.set(false);
            this.globalUnlock();
        }
    }

    private void txRollback() {
        Rec value;
        Long id;
        for (Map.Entry e : this.txChanges.entrySet()) {
            id = (Long)e.getKey();
            value = (Rec)e.getValue();
            U.must(value != null);
            this.data.put(id, value);
        }
        for (Map.Entry e : this.txInsertions.entrySet()) {
            id = (Long)e.getKey();
            value = e.getValue();
            U.must(value == INSERTION);
            Rec inserted = (Rec)this.data.remove(id);
            U.must(inserted != null);
        }
    }

    private <T> T get_(long id, Class<T> clazz) {
        this.validateId(id);
        Rec rec = (Rec)this.data.get(id);
        return rec != null ? (T)InMem.setId(JSON.parse(rec.json, clazz), id) : null;
    }

    private void sharedLock() {
        this.lock.readLock().lock();
    }

    private void sharedUnlock() {
        this.lock.readLock().unlock();
    }

    private void globalLock() {
        this.lock.writeLock().lock();
    }

    private void globalUnlock() {
        this.lock.writeLock().unlock();
    }

    private void validateId(long id) {
        if (!this.data.containsKey(id)) {
            throw new IllegalArgumentException("Cannot find DB record with id=" + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream output) {
        this.globalLock();
        try {
            PrintWriter out = new PrintWriter(output);
            for (Map.Entry entry : this.data.entrySet()) {
                String json = ((Rec)entry.getValue()).json;
                out.println(json);
            }
            out.close();
        }
        finally {
            this.globalUnlock();
        }
    }

    public void load(InputStream in) {
        this.globalLock();
        try {
            String line;
            this.data.clear();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                Class<?> type;
                Map map = JSON.parse(line, Map.class);
                Long id = new Long((String)map.get("id"));
                String className = (String)map.get("_class");
                try {
                    type = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    type = null;
                }
                this.data.put(id, new Rec(type, line));
                if (id <= this.ids.get()) continue;
                this.ids.set(id);
            }
            this.prevData = new ConcurrentSkipListMap<Long, Rec>((SortedMap<Long, Rec>)this.data);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load database!", e);
        }
        finally {
            this.globalUnlock();
        }
    }

    private void persistTo(RandomAccessFile file) throws IOException {
        for (Map.Entry entry : this.data.entrySet()) {
            String json = ((Rec)entry.getValue()).json;
            file.write(json.getBytes());
            file.write(CR_LF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistData(Runnable onCommit, Runnable onRollback) {
        ConcurrentSkipListMap<Long, Rec> copy;
        this.globalLock();
        try {
            if (this.data.isEmpty()) {
                return;
            }
            copy = new ConcurrentSkipListMap<Long, Rec>((SortedMap<Long, Rec>)this.data);
        }
        finally {
            this.globalUnlock();
        }
        try {
            File file = this.currentFile();
            if (file.exists()) {
                throw new IllegalStateException("Cannot save the database, file already exists: " + file.getAbsolutePath());
            }
            RandomAccessFile ff = new RandomAccessFile(file, "rw");
            this.persistTo(ff);
            ff.getChannel().force(false);
            ff.close();
            this.prevData = copy;
            boolean isA = this.aOrB.get();
            InMem.must(this.aOrB.compareAndSet(isA, !isA), "DB persistence file switching error!", new Object[0]);
            File oldFile = this.currentFile();
            oldFile.delete();
            try {
                if (onCommit != null) {
                    onCommit.run();
                }
            }
            catch (Throwable e) {
                InMem.error("Tx commit callback error", e);
            }
        }
        catch (IOException e) {
            try {
                if (onRollback != null) {
                    onRollback.run();
                }
            }
            catch (Throwable e2) {
                InMem.error("Tx rollback callback error", e2);
            }
            this.data = new ConcurrentSkipListMap<Long, Rec>((SortedMap<Long, Rec>)this.prevData);
            throw new RuntimeException("Cannot persist database changes!", e);
        }
    }

    private File currentFile() {
        return new File(this.filenameWithSuffix(this.aOrB.get() ? SUFFIX_A : SUFFIX_B));
    }

    private File otherFile() {
        return new File(this.filenameWithSuffix(!this.aOrB.get() ? SUFFIX_A : SUFFIX_B));
    }

    private String filenameWithSuffix(String suffixAorB) {
        return this.filename.replace(".db", "-" + suffixAorB + ".db");
    }

    private void persist() {
        while (!Thread.interrupted()) {
            try {
                this.persistData(null, null);
            }
            catch (Exception e1) {
                InMem.error("Failed to persist data!", e1);
            }
            if (this.active.get()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
                continue;
            }
            try {
                this.persistData(null, null);
            }
            catch (Exception e1) {
                InMem.error("Failed to persist data!", e1);
            }
            return;
        }
    }

    public void shutdown() {
        this.active.set(false);
        try {
            this.persistor.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        new File(this.filename).delete();
    }

    public boolean isActive() {
        return this.active.get();
    }

    public String toString() {
        return super.toString() + "[filename=" + this.filename + "]";
    }

    public void start() {
        if (!this.active.get()) {
            throw new IllegalStateException("Starting the database after shutdown is not implemented yet!");
        }
    }

    public void halt() {
        if (this.active.get()) {
            this.active.set(false);
            this.persistor.interrupt();
            try {
                this.persistor.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void destroy() {
        this.halt();
        new File(this.filename).delete();
        new File(this.filenameWithSuffix(SUFFIX_A)).delete();
        new File(this.filenameWithSuffix(SUFFIX_B)).delete();
    }

    private static Rec rec(Object record, long id) {
        String _class = record.getClass().getCanonicalName();
        return new Rec(record.getClass(), JSON.stringifyWithExtras(record, "_class", _class, "id", id));
    }

    private static <T> T obj(Rec rec) {
        return (T)JSON.parse(rec.json, rec.type);
    }

    private static <T> T setId(T record, long id) {
        if (record != null) {
            if (record instanceof Map) {
                ((Map)record).put("id", id);
            }
            try {
                InMem.setObjId(record, id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return record;
    }

    private static void must(boolean condition, String msg, Object ... args) {
        if (!condition) {
            throw new RuntimeException(String.format(msg, args));
        }
    }

    private static void error(String msg, Throwable e) {
        System.err.println(msg);
        e.printStackTrace();
    }

    private static void setObjId(Object obj, long id) {
        Class<?> c = obj.getClass();
        try {
            try {
                c.getMethod("setId", Long.TYPE).invoke(obj, id);
                return;
            }
            catch (NoSuchMethodException e1) {
                try {
                    c.getMethod("id", Long.TYPE).invoke(obj, id);
                    return;
                }
                catch (NoSuchMethodException e2) {
                    try {
                        c.getField("id").set(obj, id);
                        return;
                    }
                    catch (NoSuchFieldException e3) {
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get object id!", e);
        }
        throw new RuntimeException("Cannot find public 'id' field nor 'setId' setter method nor 'id' setter method in class: " + c);
    }

    private static long getObjId(Object obj) {
        Class<?> c = obj.getClass();
        try {
            try {
                return ((Number)c.getMethod("getId", new Class[0]).invoke(obj, new Object[0])).longValue();
            }
            catch (NoSuchMethodException e1) {
                try {
                    return ((Number)c.getMethod("id", new Class[0]).invoke(obj, new Object[0])).longValue();
                }
                catch (NoSuchMethodException e2) {
                    try {
                        return ((Number)c.getField("id").get(obj)).longValue();
                    }
                    catch (NoSuchFieldException e3) {
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get object id!", e);
        }
        throw new RuntimeException("Cannot find public 'id' field nor 'getId' getter method nor 'id' getter method in class: " + c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.globalLock();
        try {
            int n = this.data.size();
            return n;
        }
        finally {
            this.globalUnlock();
        }
    }
}

