/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.json;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.OutputStream;
import java.util.Map;

public class JSON {
    private static final ObjectMapper MAPPER = JSON.mapper();

    private static ObjectMapper mapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public static String stringify(Object value) {
        try {
            return MAPPER.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String stringifyWithExtras(Object value, Object ... extras) {
        if (extras.length % 2 != 0) {
            throw new IllegalArgumentException("Expected even number of extras (key1, value1, key2, value2...), but found: " + extras.length);
        }
        try {
            Object node = MAPPER.valueToTree(value);
            if (!(node instanceof ObjectNode)) {
                throw new RuntimeException("Cannot add extra attributes on a non-object value: " + value);
            }
            ObjectNode obj = (ObjectNode)node;
            int extrasN = extras.length / 2;
            for (int i = 0; i < extrasN; ++i) {
                Object key = extras[2 * i];
                if (!(key instanceof String)) {
                    throw new RuntimeException("Expected extra key of type String, but found: " + key);
                }
                obj.put((String)key, String.valueOf(extras[2 * i + 1]));
            }
            return MAPPER.writeValueAsString(node);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void stringify(Object value, OutputStream out) {
        try {
            MAPPER.writeValue(out, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(String json, Class<T> valueType) {
        try {
            return MAPPER.readValue(json, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> parseMap(String json) {
        return JSON.parse(json, Map.class);
    }

    public static void warmup() {
        JSON.stringify(123);
        JSON.parse("{}", Map.class);
    }
}

