/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.model;

import java.util.List;
import java.util.Map;
import org.rapidoid.model.Item;
import org.rapidoid.model.Items;
import org.rapidoid.model.Property;
import org.rapidoid.model.impl.BeanItem;
import org.rapidoid.model.impl.BeanListItems;
import org.rapidoid.model.impl.BeanProperty;
import org.rapidoid.model.impl.ListItems;
import org.rapidoid.util.Cls;
import org.rapidoid.util.Prop;
import org.rapidoid.util.U;

public class Model {
    public static Items items(Object ... values) {
        ListItems items = new ListItems();
        for (Object value : values) {
            items.add(Model.item(value));
        }
        return items;
    }

    public static <T> Items beanItems(Class<T> beanType, Object ... beans) {
        BeanListItems<T> items = new BeanListItems<T>(beanType);
        for (Object bean : beans) {
            items.add(Model.item(bean));
        }
        return items;
    }

    public static <T> Items beanItemsInfer(T ... items) {
        U.must(items.length > 0, "Must have at least 1 item to infer the bean type!");
        Class<?> type = items[0].getClass();
        return Model.beanItems(type, items);
    }

    public static Item item(Object value) {
        return new BeanItem(value);
    }

    public static Property propertyOf(Class<?> beanType, String property) {
        Map<String, Prop> props = Cls.propertiesOf(beanType);
        Prop prop = props.get(property);
        U.must(prop != null, "Cannot find property %s in class %s!", property, beanType);
        return new BeanProperty(prop.getName(), prop.getType());
    }

    public static List<Property> propertiesOf(Class<?> beanType, String ... propertyNames) {
        List<Object> pr = U.list(new Object[0]);
        Map<String, Prop> props = Cls.propertiesOf(beanType);
        if (propertyNames.length == 0) {
            Prop idProp = props.get("id");
            if (idProp != null) {
                pr.add(new BeanProperty(idProp.getName(), idProp.getType()));
            }
            for (Prop prop : props.values()) {
                if (prop.getName().equals("id")) continue;
                pr.add(new BeanProperty(prop.getName(), prop.getType()));
            }
        } else {
            for (String propName : propertyNames) {
                Prop prop = props.get(propName);
                U.must(prop != null, "Cannot find property '%s' in type: %s", propName, beanType);
                pr.add(new BeanProperty(prop.getName(), prop.getType()));
            }
        }
        return pr;
    }

    public static List<Property> editablePropertiesOf(Class<?> beanType, String ... propertyNames) {
        List<Object> pr = U.list(new Object[0]);
        Map<String, Prop> props = Cls.propertiesOf(beanType);
        if (propertyNames.length == 0) {
            for (Prop prop : props.values()) {
                if (prop.getName().equalsIgnoreCase("id")) continue;
                pr.add(new BeanProperty(prop.getName(), prop.getType()));
            }
        } else {
            for (String propName : propertyNames) {
                Prop prop = props.get(propName);
                U.must(prop != null, "Cannot find property '%s' in type: %s", propName, beanType);
                pr.add(new BeanProperty(prop.getName(), prop.getType()));
            }
        }
        return pr;
    }

    public static <T> Items mockBeanItems(int size, Class<T> beanType) {
        Object[] beans = new Object[size];
        for (int i = 0; i < beans.length; ++i) {
            beans[i] = U.newInstance(beanType);
            Cls.setId(beans[i], i);
        }
        return Model.beanItems(beanType, beans);
    }
}

