/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.model.impl;

import java.util.List;
import org.rapidoid.model.Item;
import org.rapidoid.model.Model;
import org.rapidoid.model.Property;
import org.rapidoid.model.impl.ListItems;
import org.rapidoid.util.U;

public class BeanListItems<T>
extends ListItems {
    private static final long serialVersionUID = 7346765152583871241L;
    protected final Class<T> beanType;
    protected final List<Property> properties;

    public BeanListItems(Class<T> beanType) {
        this.beanType = beanType;
        this.properties = Model.propertiesOf(beanType, new String[0]);
    }

    @Override
    public List<Property> properties(String ... propertyNames) {
        return propertyNames.length == 0 ? this.properties : this.filterProperties(propertyNames);
    }

    private List<Property> filterProperties(String[] propertyNames) {
        List<Object> props = U.list(new Object[0]);
        for (String pr : propertyNames) {
            props.add(Model.propertyOf(this.beanType, pr));
        }
        return props;
    }

    @Override
    public boolean fitsIn(Item item) {
        return super.fitsIn(item) && U.instanceOf(item.value(), this.beanType);
    }
}

