/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.rapidoid.model.Item;
import org.rapidoid.model.Items;
import org.rapidoid.model.Property;
import org.rapidoid.util.U;

public class ListItems
implements Items {
    private static final long serialVersionUID = -4233673233447713903L;
    private final List<Item> list = new ArrayList<Item>();

    @Override
    public void insert(int index, Item item) {
        this.data().add(index, this.ifFitsIn(item));
    }

    @Override
    public void add(Item item) {
        this.data().add(this.ifFitsIn(item));
    }

    @Override
    public void addAll(Items items) {
        for (int i = 0; i < items.size(); ++i) {
            this.data().add(this.ifFitsIn(items.get(i)));
        }
    }

    @Override
    public void addAll(List<Item> items) {
        for (Item item : items) {
            this.data().add(this.ifFitsIn(item));
        }
    }

    @Override
    public void clear() {
        this.data().clear();
    }

    @Override
    public Item get(int index) {
        return this.data().get(index);
    }

    @Override
    public boolean isEmpty() {
        return this.data().isEmpty();
    }

    @Override
    public void remove(int index) {
        this.data().remove(index);
    }

    @Override
    public void set(int index, Item item) {
        this.data().set(index, this.ifFitsIn(item));
    }

    @Override
    public int size() {
        return this.data().size();
    }

    @Override
    public Items range(int fromIndex, int toIndex) {
        ListItems subitems = new ListItems();
        subitems.addAll(this.data().subList(fromIndex, toIndex));
        return subitems;
    }

    @Override
    public List<Property> properties(String ... propertyNames) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean fitsIn(Item item) {
        return item.value() != null;
    }

    protected final Item ifFitsIn(Item item) {
        U.must(this.fitsIn(item), "This item doesn't fit in the items: %s", item);
        return item;
    }

    @Override
    public Iterator<Item> iterator() {
        return this.data().iterator();
    }

    protected List<Item> data() {
        return this.list;
    }
}

