/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import org.rapidoid.activity.LifecycleActivity;
import org.rapidoid.net.impl.LoopStatus;
import org.rapidoid.util.U;

public abstract class AbstractLoop<T>
extends LifecycleActivity<T>
implements Runnable {
    protected Thread ownerThread;
    protected volatile LoopStatus status = LoopStatus.INIT;

    public AbstractLoop(String name) {
        super(name);
    }

    @Override
    public void run() {
        this.ownerThread = Thread.currentThread();
        U.info("Starting event loop", "name", this.name);
        this.setStatus(LoopStatus.BEFORE_LOOP);
        try {
            this.beforeLoop();
        }
        catch (Throwable e) {
            U.severe("Error occured before loop is started", "name", this.name, "error", e);
            return;
        }
        this.setStatus(LoopStatus.LOOP);
        while (this.status == LoopStatus.LOOP && !Thread.currentThread().isInterrupted()) {
            try {
                this.insideLoop();
            }
            catch (Throwable e) {
                U.severe("Event loop exception in " + this.name, e);
            }
        }
        this.setStatus(LoopStatus.AFTER_LOOP);
        this.afterLoop();
        this.setStatus(LoopStatus.STOPPED);
        U.info("Stopped event loop", "name", this.name);
    }

    private void setStatus(LoopStatus status) {
        this.status = status;
    }

    protected synchronized void stopLoop() {
        U.info("Stopping event loop", "name", this.name);
        while (this.status == LoopStatus.INIT || this.status == LoopStatus.BEFORE_LOOP) {
            try {
                Thread.sleep(100L);
                U.info("Waiting for event loop to initialize...", "name", this.name);
            }
            catch (InterruptedException interruptedException) {}
        }
        U.info("Stopped event loop", "name", this.name);
        if (this.status == LoopStatus.LOOP) {
            this.status = LoopStatus.STOPPED;
        }
    }

    protected void beforeLoop() {
    }

    protected abstract void insideLoop();

    protected void afterLoop() {
    }

    protected void assertStatus(LoopStatus expected) {
        if (this.status != expected) {
            throw new IllegalStateException("Expected status=" + (Object)((Object)expected) + " for event loop: " + this.name);
        }
    }

    protected boolean onSameThread() {
        return this.ownerThread == Thread.currentThread();
    }

    protected void checkOnSameThread() {
        if (!this.onSameThread()) {
            throw U.rte("Not on the owner thread, expected %s, but found: %s", this.ownerThread, Thread.currentThread());
        }
    }
}

