/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import java.io.File;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.rapidoid.buffer.Buf;
import org.rapidoid.buffer.BufProvider;
import org.rapidoid.data.BinaryMultiData;
import org.rapidoid.data.Data;
import org.rapidoid.data.KeyValueRanges;
import org.rapidoid.data.MultiData;
import org.rapidoid.data.Range;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.net.abstracts.CtxFull;
import org.rapidoid.net.impl.DecodedData;
import org.rapidoid.net.impl.DefaultBinaryMultiData;
import org.rapidoid.net.impl.DefaultData;
import org.rapidoid.net.impl.DefaultMultiData;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.util.Constants;
import org.rapidoid.util.Resetable;
import org.rapidoid.util.U;

public abstract class DefaultExchange<T, W>
implements CtxFull<T, W>,
BufProvider,
Resetable,
Constants {
    protected Channel conn;
    protected AtomicLong totalWritten = new AtomicLong();

    @Override
    public synchronized void reset() {
        this.conn = null;
        this.totalWritten.set(0L);
    }

    public void setConnection(Channel conn) {
        this.conn = conn;
    }

    @Override
    public String address() {
        return this.conn.address();
    }

    @Override
    public W write(String s) {
        byte[] bytes = s.getBytes();
        this.conn.write(bytes);
        return this.wrote(bytes.length);
    }

    @Override
    public W writeln(String s) {
        byte[] bytes = s.getBytes();
        this.conn.write(bytes);
        this.conn.write(CR_LF);
        return this.wrote(bytes.length + 2);
    }

    @Override
    public W write(byte[] bytes) {
        this.conn.write(bytes);
        return this.wrote(bytes.length);
    }

    @Override
    public W write(byte[] bytes, int offset, int length) {
        this.conn.write(bytes, offset, length);
        return this.wrote(length);
    }

    @Override
    public W write(ByteBuffer buf) {
        int n = buf.remaining();
        this.conn.write(buf);
        return this.wrote(n);
    }

    @Override
    public W write(File file) {
        long size = file.length();
        U.must(size < Integer.MAX_VALUE);
        this.conn.write(file);
        return this.wrote((int)size);
    }

    @Override
    public W writeJSON(Object value) {
        this.conn.writeJSON(value);
        return this.meW();
    }

    private W wrote(int count) {
        this.totalWritten.addAndGet(count);
        return this.meW();
    }

    @Override
    public T close() {
        this.conn.close();
        return this.meT();
    }

    @Override
    public T closeIf(boolean condition) {
        this.conn.closeIf(condition);
        return this.meT();
    }

    @Override
    public Buf input() {
        return this.conn.input();
    }

    @Override
    public Buf output() {
        return this.conn.output();
    }

    @Override
    public String readln() {
        return this.conn.readln();
    }

    @Override
    public String readN(int count) {
        return this.conn.readN(count);
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.conn.getAddress();
    }

    @Override
    public RapidoidHelper helper() {
        return this.conn.helper();
    }

    @Override
    public long connId() {
        return this.conn.connId();
    }

    protected Data data(Range range) {
        return new DefaultData(this, range);
    }

    protected Data decodedData(Range range) {
        return new DecodedData(this, range);
    }

    protected MultiData multiData(KeyValueRanges ranges) {
        return new DefaultMultiData(this, ranges);
    }

    protected BinaryMultiData binaryMultiData(KeyValueRanges ranges) {
        return new DefaultBinaryMultiData(this, ranges);
    }

    @Override
    public Buf buffer() {
        return this.conn.input();
    }

    public long getTotalWritten() {
        return this.totalWritten.get();
    }

    @Override
    public T restart() {
        this.conn.restart();
        return this.meT();
    }

    @Override
    public W async() {
        this.conn.async();
        return this.meW();
    }

    @Override
    public W done() {
        this.conn.done();
        return this.meW();
    }

    protected T meT() {
        return (T)this;
    }

    protected W meW() {
        return (W)this;
    }
}

