/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.rapidoid.annotation.Inject;
import org.rapidoid.buffer.BufGroup;
import org.rapidoid.net.TCPClient;
import org.rapidoid.net.impl.AbstractEventLoop;
import org.rapidoid.net.impl.ConnectionTarget;
import org.rapidoid.net.impl.DefaultExchange;
import org.rapidoid.net.impl.Protocol;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.net.impl.RapidoidWorker;
import org.rapidoid.util.U;

public class RapidoidClientLoop
extends AbstractEventLoop<TCPClient>
implements TCPClient {
    private RapidoidWorker[] workers;
    @Inject(optional=true)
    private String host = null;
    @Inject(optional=true)
    private int port = 80;
    @Inject(optional=true)
    private int workersN = U.cpus();
    @Inject(optional=true)
    private int bufSizeKB = 16;
    @Inject(optional=true)
    private boolean noDelay = false;
    @Inject(optional=true)
    private int connections = 1;
    private final Protocol protocol;
    private final Class<? extends RapidoidHelper> helperClass;
    private final Class<? extends DefaultExchange<?, ?>> exchangeClass;

    public RapidoidClientLoop(Protocol protocol, Class<? extends DefaultExchange<?, ?>> exchangeClass, Class<? extends RapidoidHelper> helperClass) {
        super("client");
        this.protocol = protocol;
        this.exchangeClass = exchangeClass;
        this.helperClass = U.or(helperClass, RapidoidHelper.class);
    }

    @Override
    protected void doProcessing() {
    }

    @Override
    protected final void beforeLoop() {
        try {
            this.openSockets();
        }
        catch (IOException e) {
            throw U.rte("Cannot open socket!", e);
        }
    }

    private void openSockets() throws IOException {
        U.notNull(this.host, "host", new Object[0]);
        InetSocketAddress addr = new InetSocketAddress(this.host, this.port);
        this.workers = new RapidoidWorker[this.workersN];
        for (int i = 0; i < this.workers.length; ++i) {
            RapidoidHelper helper = U.newInstance(this.helperClass, this.exchangeClass);
            String workerName = "client" + (i + 1);
            this.workers[i] = new RapidoidWorker(workerName, new BufGroup(13), this.protocol, helper, this.bufSizeKB, this.noDelay);
            new Thread((Runnable)this.workers[i], workerName).start();
        }
        int workerInd = 0;
        for (int c = 0; c < this.connections; ++c) {
            SocketChannel socketChannel = SocketChannel.open();
            if (socketChannel.isOpen()) {
                this.workers[workerInd++].connect(new ConnectionTarget(socketChannel, addr));
                if (workerInd != this.workers.length) continue;
                workerInd = 0;
                continue;
            }
            throw U.rte("Cannot open socket!");
        }
    }

    @Override
    public synchronized TCPClient start() {
        new Thread((Runnable)this, "client").start();
        return (TCPClient)super.start();
    }

    @Override
    public synchronized TCPClient shutdown() {
        this.stopLoop();
        for (RapidoidWorker worker : this.workers) {
            worker.stopLoop();
        }
        return (TCPClient)super.shutdown();
    }
}

