/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.rapidoid.annotation.Inject;
import org.rapidoid.buffer.BufGroup;
import org.rapidoid.net.TCPServer;
import org.rapidoid.net.impl.AbstractEventLoop;
import org.rapidoid.net.impl.DefaultExchange;
import org.rapidoid.net.impl.Protocol;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.net.impl.RapidoidWorker;
import org.rapidoid.util.U;

public class RapidoidServerLoop
extends AbstractEventLoop<TCPServer>
implements TCPServer {
    private RapidoidWorker[] workers;
    private int workerIndex = 0;
    @Inject(optional=true)
    private int port = 8080;
    @Inject(optional=true)
    private int workersN = U.cpus();
    @Inject(optional=true)
    private int bufSizeKB = 16;
    @Inject(optional=true)
    private boolean noDelay = false;
    protected final Protocol protocol;
    private final Class<? extends RapidoidHelper> helperClass;
    private final Class<? extends DefaultExchange<?, ?>> exchangeClass;
    private ServerSocketChannel serverSocketChannel;

    public RapidoidServerLoop(Protocol protocol, Class<? extends DefaultExchange<?, ?>> exchangeClass, Class<? extends RapidoidHelper> helperClass) {
        super("server");
        this.protocol = protocol;
        this.exchangeClass = exchangeClass;
        this.helperClass = U.or(helperClass, RapidoidHelper.class);
    }

    @Override
    protected void acceptOP(SelectionKey key) throws IOException {
        ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
        SocketChannel socketChannel = serverChannel.accept();
        RapidoidWorker worker = this.workers[this.workerIndex];
        ++this.workerIndex;
        if (this.workerIndex >= this.workers.length) {
            this.workerIndex = 0;
        }
        worker.accept(socketChannel);
    }

    @Override
    protected void doProcessing() {
    }

    @Override
    protected final void beforeLoop() {
        try {
            this.openSocket();
        }
        catch (IOException e) {
            throw U.rte("Cannot open socket!", e);
        }
    }

    private void openSocket() throws IOException {
        U.notNull(this.protocol, "protocol", new Object[0]);
        U.notNull(this.helperClass, "helperClass", new Object[0]);
        this.serverSocketChannel = ServerSocketChannel.open();
        if (this.serverSocketChannel.isOpen() && this.selector.isOpen()) {
            this.serverSocketChannel.configureBlocking(false);
            ServerSocket socket = this.serverSocketChannel.socket();
            InetSocketAddress addr = new InetSocketAddress(this.port);
            socket.bind(addr);
            U.info("Opened socket", "address", addr);
            this.serverSocketChannel.register(this.selector, 16);
            U.info("Waiting for connections...");
            this.workers = new RapidoidWorker[this.workersN];
            for (int i = 0; i < this.workers.length; ++i) {
                RapidoidHelper helper = U.newInstance(this.helperClass, this.exchangeClass);
                String workerName = "server" + (i + 1);
                BufGroup bufGroup = new BufGroup(14);
                this.workers[i] = new RapidoidWorker(workerName, bufGroup, this.protocol, helper, this.bufSizeKB, this.noDelay);
                new Thread((Runnable)this.workers[i], workerName).start();
            }
        } else {
            throw U.rte("Cannot open socket!");
        }
    }

    @Override
    public synchronized TCPServer start() {
        new Thread((Runnable)this, "server").start();
        return (TCPServer)super.start();
    }

    @Override
    public synchronized TCPServer shutdown() {
        this.stopLoop();
        for (RapidoidWorker worker : this.workers) {
            worker.stopLoop();
        }
        if (this.serverSocketChannel.isOpen() && this.selector.isOpen()) {
            try {
                this.selector.close();
                this.serverSocketChannel.close();
            }
            catch (IOException e) {
                U.warn("Cannot close socket or selector!", e);
            }
        }
        return (TCPServer)super.shutdown();
    }
}

