/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.oauth;

import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.rapidoid.http.HTMLSnippets;
import org.rapidoid.http.HTTPServer;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.oauth.DefaultOAuthStateCheck;
import org.rapidoid.oauth.OAuthLoginHandler;
import org.rapidoid.oauth.OAuthProvider;
import org.rapidoid.oauth.OAuthStateCheck;
import org.rapidoid.oauth.OAuthTokenHandler;
import org.rapidoid.util.U;

public class OAuth {
    private static final String LOGIN_BTN = "<div class=\"row-fluid\"><div class=\"col-md-3\"><a href=\"/_%sLogin\" class=\"btn btn-default btn-block\">Login with %s</a></div></div>";
    private static OAuthStateCheck STATE_CHECK;

    public static void register(HTTPServer server, OAuthProvider ... providers) {
        OAuth.register(server, null, new DefaultOAuthStateCheck(), providers);
    }

    public static void register(HTTPServer server, String oauthDomain, OAuthStateCheck stateCheck, OAuthProvider ... providers) {
        oauthDomain = U.or(oauthDomain, U.option("oauth-domain", null));
        STATE_CHECK = stateCheck;
        if (providers == null || providers.length == 0) {
            providers = OAuthProvider.PROVIDERS;
        }
        final StringBuilder loginHtml = new StringBuilder();
        loginHtml.append("<div class=\"container-fluid text-center\">");
        for (OAuthProvider provider : providers) {
            String name = provider.getName().toLowerCase();
            String loginPath = "/_" + name + "Login";
            String callbackPath = "/_" + name + "OauthCallback";
            String clientId = U.config(name + ".clientId");
            String clientSecret = U.config(name + ".clientSecret");
            server.get(loginPath, new OAuthLoginHandler(provider, oauthDomain));
            server.get(callbackPath, new OAuthTokenHandler(provider, oauthDomain, stateCheck, clientId, clientSecret, callbackPath));
            loginHtml.append(U.format(LOGIN_BTN, name, provider.getName()));
        }
        loginHtml.append("</div>");
        server.get("/_oauthLogin", new Handler(){

            @Override
            public Object handle(HttpExchange x) throws Exception {
                return HTMLSnippets.writePage(x, "Login with OAuth provider", loginHtml.toString());
            }
        });
    }

    public static String getLoginURL(HttpExchange x, OAuthProvider provider, String oauthDomain) {
        oauthDomain = U.or(oauthDomain, U.option("oauth-domain", null));
        String name = provider.getName().toLowerCase();
        String clientId = U.config(name + ".clientId");
        String clientSecret = U.config(name + ".clientSecret");
        String callbackPath = "/_" + name + "OauthCallback";
        String redirectUrl = oauthDomain != null ? oauthDomain + callbackPath : x.constructUrl(callbackPath);
        String state = STATE_CHECK.generateState(clientSecret, x.sessionId());
        try {
            OAuthClientRequest request = OAuthClientRequest.authorizationLocation(provider.getAuthEndpoint()).setClientId(clientId).setRedirectURI(redirectUrl).setScope(provider.getEmailScope()).setState(state).setResponseType("code").buildQueryMessage();
            return request.getLocationUri();
        }
        catch (OAuthSystemException e) {
            throw U.rte(e);
        }
    }
}

