/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.oauth;

public class OAuthProvider {
    public static OAuthProvider GOOGLE = new OAuthProvider("Google", "https://accounts.google.com/o/oauth2/auth", "https://accounts.google.com/o/oauth2/token", "https://www.googleapis.com/oauth2/v1/userinfo", "profile", "email");
    public static OAuthProvider FACEBOOK = new OAuthProvider("Facebook", "https://graph.facebook.com/oauth/authorize", "https://graph.facebook.com/oauth/access_token", "https://graph.facebook.com/me", "public_profile", "email");
    public static OAuthProvider LINKEDIN = new OAuthProvider("LinkedIn", "https://www.linkedin.com/uas/oauth2/authorization", "https://www.linkedin.com/uas/oauth2/accessToken", "https://api.linkedin.com/v1/people/~:(id,first-name,last-name,maiden-name,email-address)?format=json&oauth2_access_token={{token}}", "r_basicprofile", "r_emailaddress");
    public static OAuthProvider GITHUB = new OAuthProvider("GitHub", "https://github.com/login/oauth/authorize", "https://github.com/login/oauth/access_token", "https://api.github.com/user", "", "user:email");
    public static final OAuthProvider[] PROVIDERS = new OAuthProvider[]{GOOGLE, FACEBOOK, LINKEDIN, GITHUB};
    private final String name;
    private final String authEndpoint;
    private final String tokenEndpoint;
    private final String profileEndpoint;
    private final String profileScope;
    private final String emailScope;

    public OAuthProvider(String name, String authEndpoint, String tokenEndpoint, String profileEndpoint, String profileScope, String emailScope) {
        this.name = name;
        this.authEndpoint = authEndpoint;
        this.tokenEndpoint = tokenEndpoint;
        this.profileEndpoint = profileEndpoint;
        this.profileScope = profileScope;
        this.emailScope = emailScope;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthEndpoint() {
        return this.authEndpoint;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public String getProfileEndpoint() {
        return this.profileEndpoint;
    }

    public String getProfileScope() {
        return this.profileScope;
    }

    public String getEmailScope() {
        return this.emailScope;
    }
}

