/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.oauth;

import java.util.Map;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.GitHubTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthResourceResponse;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.http.UserInfo;
import org.rapidoid.json.JSON;
import org.rapidoid.oauth.OAuthProvider;
import org.rapidoid.oauth.OAuthStateCheck;
import org.rapidoid.util.U;

public class OAuthTokenHandler
implements Handler {
    private final OAuthProvider provider;
    private final String oauthDomain;
    private final OAuthStateCheck stateCheck;
    private final String clientId;
    private final String clientSecret;
    private final String callbackPath;

    public OAuthTokenHandler(OAuthProvider provider, String oauthDomain, OAuthStateCheck stateCheck, String clientId, String clientSecret, String callbackPath) {
        this.provider = provider;
        this.oauthDomain = oauthDomain;
        this.stateCheck = stateCheck;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.callbackPath = callbackPath;
    }

    @Override
    public Object handle(HttpExchange x) throws Exception {
        String code = x.param("code");
        String state = x.param("state");
        U.debug("Received OAuth code", "code", code, "state", state);
        if (code != null && state != null) {
            U.must(this.stateCheck.isValidState(state, this.clientSecret, x.sessionId()), "Invalid OAuth state!");
            String redirectUrl = this.oauthDomain != null ? this.oauthDomain + this.callbackPath : x.constructUrl(this.callbackPath);
            OAuthClientRequest.TokenRequestBuilder reqBuilder = OAuthClientRequest.tokenLocation(this.provider.getTokenEndpoint()).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId(this.clientId).setClientSecret(this.clientSecret).setRedirectURI(redirectUrl).setCode(code);
            OAuthClientRequest request = this.paramsInBody() ? reqBuilder.buildBodyMessage() : reqBuilder.buildBodyMessage();
            OAuthClient oAuthClient = new OAuthClient(new URLConnectionClient());
            String accessToken = this.token(request, oAuthClient);
            String profileUrl = U.fillIn(this.provider.getProfileEndpoint(), "token", accessToken);
            OAuthClientRequest bearerClientRequest = new OAuthBearerClientRequest(profileUrl).setAccessToken(accessToken).buildQueryMessage();
            OAuthResourceResponse res = oAuthClient.resource(bearerClientRequest, "GET", OAuthResourceResponse.class);
            U.must(res.getResponseCode() == 200, "OAuth response error!");
            Map<String, Object> auth = JSON.parseMap(res.getBody());
            String firstName = (String)U.or(auth.get("firstName"), U.or(auth.get("first_name"), auth.get("given_name")));
            String lastName = (String)U.or(auth.get("lastName"), U.or(auth.get("last_name"), auth.get("family_name")));
            UserInfo user = new UserInfo();
            user.name = U.or((String)auth.get("name"), firstName + " " + lastName);
            user.oauthProvider = this.provider.getName();
            user.username = user.email = (String)U.or(auth.get("email"), auth.get("emailAddress"));
            user.oauthId = String.valueOf(auth.get("id"));
            user.display = user.email.substring(0, user.email.indexOf(64));
            x.sessionSet("_user", user);
            U.must(x.user() == user);
            return x.redirect("/");
        }
        String error = x.param("error");
        if (error != null) {
            U.warn("OAuth error", "error", error);
            throw U.rte("OAuth error!");
        }
        throw U.rte("OAuth error!");
    }

    private String token(OAuthClientRequest request, OAuthClient oAuthClient) throws Exception {
        String name = this.provider.getName();
        if (name.equalsIgnoreCase("facebook") || name.equalsIgnoreCase("github")) {
            GitHubTokenResponse oAuthResponse = oAuthClient.accessToken(request, GitHubTokenResponse.class);
            return oAuthResponse.getAccessToken();
        }
        OAuthJSONAccessTokenResponse oAuthResponse = oAuthClient.accessToken(request, OAuthJSONAccessTokenResponse.class);
        return oAuthResponse.getAccessToken();
    }

    private boolean paramsInBody() {
        return this.provider.getName().equalsIgnoreCase("google");
    }
}

