/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.pages;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.regex.Pattern;
import org.rapidoid.html.Cmd;
import org.rapidoid.html.TagContext;
import org.rapidoid.html.Tags;
import org.rapidoid.http.HTTPServer;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.inject.IoC;
import org.rapidoid.json.JSON;
import org.rapidoid.pages.BootstrapWidgets;
import org.rapidoid.pages.EmitHandler;
import org.rapidoid.pages.PageHandler;
import org.rapidoid.pages.impl.BuiltInCmdHandler;
import org.rapidoid.pages.impl.PageRenderer;
import org.rapidoid.pojo.PojoDispatchException;
import org.rapidoid.pojo.PojoHandlerNotFoundException;
import org.rapidoid.rest.WebPojoDispatcher;
import org.rapidoid.rest.WebReq;
import org.rapidoid.util.Cls;
import org.rapidoid.util.U;

public class Pages {
    public static final String SESSION_CTX = "_ctx";
    public static final String SESSION_CURRENT_PAGE = "_current_page_";
    private static final Pattern STATIC_RESOURCE_PATTERN = Pattern.compile("^[a-zA-Z0-9_\\.\\-/]+$");
    private static final BuiltInCmdHandler BUILT_IN_HANDLER = new BuiltInCmdHandler();

    public static void registerPages(HTTPServer server) {
        server.post("/_emit", new EmitHandler());
        server.serve(new PageHandler());
    }

    protected static Map<Integer, Object> inputs(HttpExchange x) {
        String inputs = x.data("inputs");
        U.notNull(inputs, "inputs", new Object[0]);
        Map<Integer, Object> inputsMap = U.map();
        Map inp = JSON.parse(inputs, Map.class);
        for (Map.Entry e : inp.entrySet()) {
            inputsMap.put(U.num((String)e.getKey()), e.getValue());
        }
        return inputsMap;
    }

    public static TagContext ctx(HttpExchange x) {
        return (TagContext)x.session(SESSION_CTX);
    }

    public static String pageName(HttpExchange x) {
        String path = x.path();
        if (path.endsWith(".html")) {
            path = U.mid(path, 0, -5);
        }
        if (path.equals("/")) {
            path = "/index";
        }
        return U.capitalized(path.substring(1));
    }

    public static String defaultPageTitle(Class<?> pageClass) {
        String pageName = pageClass.getSimpleName();
        if (pageName.endsWith("Page")) {
            pageName = U.mid(pageName, 0, -4);
        }
        return U.camelPhrase(pageName);
    }

    public static String titleOf(HttpExchange x, Object target) {
        Method m = Cls.findMethod(target.getClass(), "title", HttpExchange.class);
        if (m != null) {
            return (String)Cls.invoke(m, target, x);
        }
        try {
            return (String)Cls.getPropValue(target, "title");
        }
        catch (Exception e) {
            return Pages.defaultPageTitle(target.getClass());
        }
    }

    public static Object contentOf(HttpExchange x, Object target) {
        Method m = Cls.findMethod(target.getClass(), "content", HttpExchange.class);
        return m != null ? Cls.invoke(m, target, x) : Cls.getPropValue(target, "content", null);
    }

    public static Object page(HttpExchange x, Object page) {
        String pageTitle = Pages.titleOf(x, page);
        Object content = Pages.contentOf(x, page);
        if (content == null) {
            return null;
        }
        if (content instanceof HttpExchange) {
            U.must(x == content, "Different HTTP exchange than expected!");
            return x;
        }
        return BootstrapWidgets.page(x.devMode(), pageTitle, content);
    }

    public static Object render(HttpExchange x, Object page) {
        Object fullPage = Pages.page(x, page);
        if (fullPage != null) {
            if (fullPage instanceof HttpExchange) {
                return x;
            }
            x.html();
            PageRenderer.get().render(Pages.ctx(x), fullPage, x);
            return x;
        }
        return x.notFound();
    }

    public static Object dispatch(HttpExchange x, WebPojoDispatcher serviceDispatcher, Map<String, Class<?>> pages) {
        String pageName;
        if (x.isGetReq()) {
            URL res;
            String filename = x.path().substring(1);
            if (filename.isEmpty()) {
                filename = "index.html";
            }
            if (!filename.contains("..") && STATIC_RESOURCE_PATTERN.matcher(filename).matches() && (res = U.resource("public/" + filename)) != null) {
                return x.sendFile(new File(res.getFile()));
            }
        }
        if (serviceDispatcher != null) {
            try {
                return serviceDispatcher.dispatch(new WebReq(x));
            }
            catch (PojoHandlerNotFoundException e) {
            }
            catch (PojoDispatchException e) {
                return x.response(500, "Cannot initialize handler argument(s)!", e);
            }
        }
        if ((pageName = Pages.pageName(x)) == null) {
            return null;
        }
        String pageClassName = U.capitalized(pageName) + "Page";
        Class<?> pageClass = pages.get(pageClassName);
        if (pageClass == null) {
            return null;
        }
        return Pages.serve(x, pageClass);
    }

    public static Object serve(HttpExchange x, Class<?> pageClass) {
        x.sessionSet(SESSION_CURRENT_PAGE, pageClass);
        Object page = U.newInstance(pageClass);
        Pages.load(x, page);
        TagContext ctx = Tags.context();
        x.sessionSet(SESSION_CTX, ctx);
        Object result = Pages.render(x, page);
        Pages.store(x, page);
        return result;
    }

    public static void load(HttpExchange x, Object target) {
        IoC.autowire(target, U.mapper(x.session()));
    }

    public static void store(HttpExchange x, Object target) {
        for (Field field : IoC.getSessionFields(target)) {
            Object value = Cls.getFieldValue(field, target);
            x.sessionSet(field.getName(), value);
        }
    }

    public static Object emit(HttpExchange x) {
        int event = U.num(x.data("event"));
        TagContext ctx = Pages.ctx(x);
        Map<Integer, Object> inp = Pages.inputs(x);
        ctx.emitValues(inp);
        Object page = U.newInstance(Pages.currentPage(x));
        Pages.load(x, page);
        Cmd cmd = ctx.getEventCmd(event);
        Pages.callCmdHandler(x, page, cmd);
        ctx = Tags.context();
        x.sessionSet(SESSION_CTX, ctx);
        Object content = Pages.contentOf(x, page);
        if (content == null || content instanceof HttpExchange) {
            return content;
        }
        String html = PageRenderer.get().toHTML(ctx, content, x);
        Pages.store(x, page);
        Map<String, String> changes = U.map();
        changes.put("body", html);
        x.json();
        return changes;
    }

    public static void callCmdHandler(HttpExchange x, Object target, Cmd cmd) {
        if (cmd.name.startsWith("_")) {
            target = BUILT_IN_HANDLER;
        }
        String handlerName = "on" + U.capitalized(cmd.name);
        Method m = Cls.findMethodByArgs(target.getClass(), handlerName, cmd.args);
        if (m != null) {
            Cls.invoke(m, target, cmd.args);
            return;
        }
        Method on = Cls.findMethod(target.getClass(), "on", String.class, Object[].class);
        if (on != null) {
            Cls.invoke(on, target, cmd.name, cmd.args);
            return;
        }
        on = Cls.findMethod(target.getClass(), "on", HttpExchange.class, String.class, Object[].class);
        if (on != null) {
            Cls.invoke(on, target, x, cmd.name, cmd.args);
            return;
        }
        throw U.rte("Cannot find handler '%s' for the command '%s' and args: %s", handlerName, cmd.name, cmd.args);
    }

    public static Class<?> currentPage(HttpExchange x) {
        return (Class)x.session(SESSION_CURRENT_PAGE);
    }
}

