/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.pojo.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.pojo.PojoDispatchException;
import org.rapidoid.pojo.PojoDispatcher;
import org.rapidoid.pojo.PojoHandlerNotFoundException;
import org.rapidoid.pojo.PojoRequest;
import org.rapidoid.pojo.impl.PojoServiceWrapper;
import org.rapidoid.util.Cls;
import org.rapidoid.util.Constants;
import org.rapidoid.util.Prop;
import org.rapidoid.util.TypeKind;
import org.rapidoid.util.U;

public class PojoDispatcherImpl
implements PojoDispatcher,
Constants {
    private static final Map<Class<?>, PojoServiceWrapper> WRAPPERS = U.autoExpandingMap(new Mapper<Class<?>, PojoServiceWrapper>(){

        @Override
        public PojoServiceWrapper map(Class<?> serviceClass) throws Exception {
            return new PojoServiceWrapper(serviceClass);
        }
    });
    private final Map<String, Class<?>> services;

    public PojoDispatcherImpl(Map<String, Class<?>> services) {
        this.services = services;
    }

    private static String nameOf(Class<?> serviceClass) {
        return U.mid(serviceClass.getSimpleName(), 0, -"Service".length());
    }

    @Override
    public Object dispatch(PojoRequest request) throws PojoHandlerNotFoundException, PojoDispatchException {
        String[] parts = PojoDispatcherImpl.uriParts(request.path());
        int length = parts.length;
        if (length == 0) {
            return this.process(request, "main", "index", parts, 0);
        }
        if (length >= 1) {
            try {
                return this.process(request, parts[0], "index", parts, 1);
            }
            catch (PojoHandlerNotFoundException e) {
                try {
                    return this.process(request, "main", parts[0], parts, 1);
                }
                catch (PojoHandlerNotFoundException e2) {
                    // empty catch block
                }
            }
        }
        if (length >= 2) {
            return this.process(request, parts[0], parts[1], parts, 2);
        }
        throw PojoDispatcherImpl.notFound();
    }

    private Object process(PojoRequest request, String service, String action, String[] parts, int paramsFrom) throws PojoHandlerNotFoundException, PojoDispatchException {
        Method method;
        PojoServiceWrapper wrapper = this.wrapper(service);
        if (wrapper != null && (method = wrapper.getMethod(action)) != null) {
            Object serviceInstance = U.newInstance(wrapper.getTarget());
            return this.doDispatch(request, method, serviceInstance, parts, paramsFrom);
        }
        throw PojoDispatcherImpl.notFound();
    }

    private PojoServiceWrapper wrapper(String service) {
        String name = U.capitalized(service) + "Service";
        Class<?> serviceClass = this.services.get(name);
        if (serviceClass == null) {
            return null;
        }
        return WRAPPERS.get(serviceClass);
    }

    private Object doDispatch(PojoRequest request, Method method, Object service, String[] parts, int paramsFrom) throws PojoHandlerNotFoundException, PojoDispatchException {
        if (method != null) {
            Object[] args;
            try {
                int paramsSize = parts.length - paramsFrom;
                Class<?>[] types = method.getParameterTypes();
                args = new Object[types.length];
                int simpleParamIndex = 0;
                for (int i = 0; i < types.length; ++i) {
                    Class<?> type = types[i];
                    TypeKind kind = Cls.kindOf(type);
                    if (kind.isSimple()) {
                        if (parts.length > paramsFrom + simpleParamIndex) {
                            args[i] = Cls.convert(parts[paramsFrom + simpleParamIndex++], type);
                            continue;
                        }
                        throw PojoDispatcherImpl.error(null, "Not enough parameters!", new Object[0]);
                    }
                    if (type.equals(Object.class)) {
                        Class<?> defaultType = this.getDefaultType(service);
                        if (defaultType != null) {
                            args[i] = this.instantiateArg(request, defaultType);
                            continue;
                        }
                        throw PojoDispatcherImpl.error(null, "Cannot provide value for parameter of type Object!", new Object[0]);
                    }
                    args[i] = this.complexArg(i, type, request, parts, paramsFrom, paramsSize);
                }
            }
            catch (Throwable e) {
                throw new PojoDispatchException("Cannot dispatch to POJO target!", e);
            }
            Object result = Cls.invoke(method, service, args);
            if (result == null && method.getReturnType().equals(Void.TYPE)) {
                result = "OK";
            }
            return result;
        }
        throw PojoDispatcherImpl.notFound();
    }

    protected Object complexArg(int i, Class<?> type, PojoRequest request, String[] parts, int paramsFrom, int paramsSize) throws PojoDispatchException {
        if (type.equals(Map.class)) {
            return this.mapArg(request, parts, paramsFrom);
        }
        if (type.equals(String[].class)) {
            return this.stringsArg(request, parts, paramsFrom, paramsSize);
        }
        if (type.equals(List.class) || type.equals(Collection.class)) {
            return this.listArg(request, parts, paramsFrom, paramsSize);
        }
        if (type.equals(Set.class)) {
            return this.setArg(request, parts, paramsFrom, paramsSize);
        }
        if (this.isCustomType(type)) {
            return this.getCustomArg(request, type, parts, paramsFrom, paramsSize);
        }
        if (type.getCanonicalName().startsWith("java")) {
            throw PojoDispatcherImpl.error(null, "Parameter type '%s' is not supported!", type.getCanonicalName());
        }
        return this.instantiateArg(request, type);
    }

    private Class<?> getDefaultType(Object service) {
        Object clazz = Cls.getPropValue(service, "clazz");
        return (Class)(clazz instanceof Class ? clazz : null);
    }

    private Object instantiateArg(PojoRequest request, Class<?> type) throws PojoDispatchException {
        try {
            Constructor<?> constructor = type.getConstructor(new Class[0]);
            try {
                Object instance = constructor.newInstance(new Object[0]);
                PojoDispatcherImpl.setBeanProperties(instance, request.params());
                return instance;
            }
            catch (Exception e) {
                throw PojoDispatcherImpl.error(e, "Cannot create a new instance of type: '%s'!", type.getCanonicalName());
            }
        }
        catch (NoSuchMethodException e) {
            throw PojoDispatcherImpl.error(e, "Cannot find a constructor with 0 parameters for type '%s'!", type.getCanonicalName());
        }
        catch (SecurityException e) {
            throw PojoDispatcherImpl.error(e, "Cannot retrieve the constructor with 0 parameters for type '%s'!", type.getCanonicalName());
        }
    }

    protected Object getCustomArg(PojoRequest request, Class<?> type, String[] parts, int paramsFrom, int paramsSize) {
        return null;
    }

    protected boolean isCustomType(Class<?> type) {
        return false;
    }

    private Set<?> setArg(PojoRequest request, String[] parts, int paramsFrom, int paramsSize) {
        if (parts.length > paramsFrom) {
            Set<Object> arguments = U.set(new Object[0]);
            for (int j = paramsFrom; j < parts.length; ++j) {
                arguments.add(parts[j]);
            }
            return arguments;
        }
        return U.set(new Object[0]);
    }

    private List<?> listArg(PojoRequest request, String[] parts, int paramsFrom, int paramsSize) {
        if (parts.length > paramsFrom) {
            ArrayList<String> arguments = new ArrayList<String>(paramsSize);
            for (int j = paramsFrom; j < parts.length; ++j) {
                arguments.add(parts[j]);
            }
            return arguments;
        }
        return U.list(new Object[0]);
    }

    private String[] stringsArg(PojoRequest request, String[] parts, int paramsFrom, int paramsSize) {
        if (parts.length > paramsFrom) {
            String[] arguments = new String[paramsSize];
            System.arraycopy(parts, paramsFrom, arguments, 0, paramsSize);
            return arguments;
        }
        return EMPTY_STRING_ARRAY;
    }

    private Map<String, String> mapArg(PojoRequest request, String[] parts, int paramsFrom) {
        Map<String, String> params = request.params();
        for (int j = paramsFrom; j < parts.length; ++j) {
            params.put("" + (j - paramsFrom + 1), parts[j]);
        }
        return params;
    }

    private static void setBeanProperties(Object instance, Map<String, String> paramsMap) {
        Map<String, Prop> props = Cls.propertiesOf(instance.getClass());
        for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
            Prop prop = props.get(entry.getKey());
            String value = entry.getValue();
            prop.set(instance, value);
        }
    }

    private static PojoDispatchException error(Throwable cause, String msg, Object ... args) {
        return new PojoDispatchException(U.format(msg, args), cause);
    }

    private static PojoHandlerNotFoundException notFound() {
        return new PojoHandlerNotFoundException();
    }

    private static String[] uriParts(String uri) {
        if (uri.isEmpty() || uri.equals("/")) {
            return EMPTY_STRING_ARRAY;
        }
        return uri.replaceAll("^/", "").replaceAll("/$", "").split("/");
    }
}

