/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.pojo.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.rapidoid.util.U;

public class PojoServiceWrapper {
    private final Map<String, Method> methods = U.map();
    private final Class<?> serviceCls;

    public PojoServiceWrapper(Class<?> serviceCls) {
        U.must(serviceCls instanceof Class);
        this.serviceCls = serviceCls;
        this.init();
    }

    private void init() {
        for (Method method : this.serviceCls.getMethods()) {
            int modifiers;
            if (method.getDeclaringClass().equals(Object.class) || Modifier.isAbstract(modifiers = method.getModifiers()) || !Modifier.isPublic(modifiers)) continue;
            this.methods.put(method.getName(), method);
            U.info("Registered web handler method: " + method);
        }
    }

    public Method getMethod(String action) {
        return this.methods.get(action);
    }

    public Class<?> getTarget() {
        return this.serviceCls;
    }
}

