/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.pool;

import java.util.concurrent.Callable;
import org.rapidoid.pool.Pool;
import org.rapidoid.util.U;

public class ArrayPool<T>
implements Pool<T> {
    private final Callable<T> factory;
    private T[] free;
    private int freeN = 0;
    private int instancesN = 0;

    public ArrayPool(Callable<T> factory, int capacity) {
        this.factory = factory;
        this.free = new Object[capacity];
    }

    @Override
    public T get() {
        if (this.freeN == 0) {
            try {
                ++this.instancesN;
                return this.factory.call();
            }
            catch (Exception e) {
                throw U.rte(e);
            }
        }
        T obj = this.free[--this.freeN];
        assert (obj != null);
        return obj;
    }

    @Override
    public void release(T obj) {
        assert (obj != null);
        if (this.freeN >= this.free.length) {
            int expandFactor = this.free.length < 1000000 ? 10 : 2;
            int newSize = this.free.length * expandFactor;
            U.warn("Pool wasn't big enough, expanding...", "old size", this.free.length, "new size", newSize);
            this.free = U.expand(this.free, expandFactor);
        }
        this.free[this.freeN++] = obj;
    }

    @Override
    public int instances() {
        return this.instancesN;
    }
}

