/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.rest;

import java.util.List;
import org.rapidoid.http.HTTP;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.pojo.POJO;
import org.rapidoid.pojo.PojoDispatchException;
import org.rapidoid.pojo.PojoDispatcher;
import org.rapidoid.pojo.PojoHandlerNotFoundException;
import org.rapidoid.rest.WebPojoDispatcher;
import org.rapidoid.rest.WebReq;
import org.rapidoid.util.U;

public class REST {
    public static void run(Class<?> ... classes) {
        REST.serve(new WebPojoDispatcher(classes));
    }

    private static void serve(final PojoDispatcher dispatcher) {
        HTTP.serve(new Handler(){

            @Override
            public Object handle(HttpExchange x) {
                try {
                    return dispatcher.dispatch(new WebReq(x));
                }
                catch (PojoHandlerNotFoundException e) {
                    return x.notFound();
                }
                catch (PojoDispatchException e) {
                    return x.response(500, "Cannot initialize handler argument(s)!", e);
                }
            }
        });
    }

    public static void start() {
        List<Class<?>> services = POJO.scanServices();
        REST.run(services.toArray(new Class[services.size()]));
    }

    public static void main(String[] args) {
        U.args(args);
        REST.start();
    }
}

