/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.util.Constants;
import org.rapidoid.util.Dates;
import org.rapidoid.util.InterceptorProxy;
import org.rapidoid.util.Prop;
import org.rapidoid.util.TypeKind;
import org.rapidoid.util.U;

public class Cls {
    static final Map<String, TypeKind> KINDS = Cls.initKinds();
    protected static final Map<Class<?>, Map<String, Prop>> BEAN_PROPERTIES = U.autoExpandingMap(new Mapper<Class<?>, Map<String, Prop>>(){

        @Override
        public Map<String, Prop> map(Class<?> clazz) throws Exception {
            LinkedHashMap<String, Prop> properties = new LinkedHashMap<String, Prop>();
            try {
                int modif;
                Class<?> c;
                for (c = clazz; c != Object.class && c != null; c = c.getSuperclass()) {
                    Method[] methods = c.getDeclaredMethods();
                    for (AccessibleObject accessibleObject : methods) {
                        Prop propInfo;
                        String propName;
                        modif = ((Method)accessibleObject).getModifiers();
                        Class<?>[] params = ((Method)accessibleObject).getParameterTypes();
                        Class<?> ret = ((Method)accessibleObject).getReturnType();
                        if ((modif & 1) <= 0 || (modif & 8) != 0 || (modif & 0x400) != 0) continue;
                        String name = ((Method)accessibleObject).getName();
                        if (name.matches("^(get|set|is)[A-Z].*")) {
                            propName = name.startsWith("is") ? name.substring(2, 3).toLowerCase() + name.substring(3) : name.substring(3, 4).toLowerCase() + name.substring(4);
                            propInfo = (Prop)properties.get(propName);
                            if (propInfo == null) {
                                propInfo = new Prop();
                                propInfo.setName(propName);
                                properties.put(propName, propInfo);
                            }
                            if (name.startsWith("set")) {
                                if (params.length != 1) continue;
                                propInfo.setSetter((Method)accessibleObject);
                                propInfo.setReadOnly(false);
                                continue;
                            }
                            if (params.length != 0) continue;
                            propInfo.setGetter((Method)accessibleObject);
                            continue;
                        }
                        if (name.matches("^to[A-Z].*")) continue;
                        if (params.length == 0 && !ret.equals(Void.TYPE)) {
                            propName = name;
                            propInfo = (Prop)properties.get(propName);
                            if (propInfo == null) {
                                propInfo = new Prop();
                                propInfo.setName(propName);
                                properties.put(propName, propInfo);
                            }
                            propInfo.setGetter((Method)accessibleObject);
                            continue;
                        }
                        if (params.length != 1) continue;
                        propName = name;
                        propInfo = (Prop)properties.get(propName);
                        if (propInfo == null) {
                            propInfo = new Prop();
                            propInfo.setName(propName);
                            properties.put(propName, propInfo);
                        }
                        propInfo.setReadOnly(false);
                        propInfo.setSetter((Method)accessibleObject);
                    }
                    Iterator it = properties.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        Prop minfo = (Prop)entry.getValue();
                        if (minfo.getGetter() != null || minfo.getSetter() == null) continue;
                        it.remove();
                    }
                }
                for (c = clazz; c != Object.class && c != null; c = c.getSuperclass()) {
                    Field[] fields = c.getDeclaredFields();
                    for (AccessibleObject accessibleObject : fields) {
                        String fieldName;
                        Prop propInfo;
                        modif = ((Field)accessibleObject).getModifiers();
                        if ((modif & 1) <= 0 || (modif & 0x10) != 0 || (modif & 8) != 0 || (propInfo = (Prop)properties.get(fieldName = ((Field)accessibleObject).getName())) != null) continue;
                        propInfo = new Prop();
                        propInfo.setName(fieldName);
                        properties.put(fieldName, propInfo);
                        propInfo.setField((Field)accessibleObject);
                    }
                }
            }
            catch (Exception e) {
                throw U.rte(e);
            }
            return properties;
        }
    });

    public static void reset() {
        BEAN_PROPERTIES.clear();
    }

    public static Map<String, Prop> propertiesOf(Class<?> clazz) {
        return BEAN_PROPERTIES.get(clazz);
    }

    public static Map<String, Prop> propertiesOf(Object obj) {
        return obj != null ? Cls.propertiesOf(obj.getClass()) : Collections.EMPTY_MAP;
    }

    public static Prop property(Class<?> clazz, String property, boolean mandatory) {
        Prop prop = BEAN_PROPERTIES.get(clazz).get(property);
        if (mandatory && prop == null) {
            throw U.rte("Cannot find the property '%s' in the class '%s'", property, clazz);
        }
        return prop;
    }

    public static Prop property(Object obj, String property, boolean mandatory) {
        return Cls.property(obj.getClass(), property, mandatory);
    }

    protected static Map<String, TypeKind> initKinds() {
        HashMap<String, TypeKind> kinds = new HashMap<String, TypeKind>();
        kinds.put("boolean", TypeKind.BOOLEAN);
        kinds.put("byte", TypeKind.BYTE);
        kinds.put("char", TypeKind.CHAR);
        kinds.put("short", TypeKind.SHORT);
        kinds.put("int", TypeKind.INT);
        kinds.put("long", TypeKind.LONG);
        kinds.put("float", TypeKind.FLOAT);
        kinds.put("double", TypeKind.DOUBLE);
        kinds.put("java.lang.String", TypeKind.STRING);
        kinds.put("java.lang.Boolean", TypeKind.BOOLEAN_OBJ);
        kinds.put("java.lang.Byte", TypeKind.BYTE_OBJ);
        kinds.put("java.lang.Character", TypeKind.CHAR_OBJ);
        kinds.put("java.lang.Short", TypeKind.SHORT_OBJ);
        kinds.put("java.lang.Integer", TypeKind.INT_OBJ);
        kinds.put("java.lang.Long", TypeKind.LONG_OBJ);
        kinds.put("java.lang.Float", TypeKind.FLOAT_OBJ);
        kinds.put("java.lang.Double", TypeKind.DOUBLE_OBJ);
        kinds.put("java.util.Date", TypeKind.DATE);
        return kinds;
    }

    public static TypeKind kindOf(Class<?> type) {
        String typeName = type.getName();
        TypeKind kind = KINDS.get(typeName);
        if (kind == null) {
            kind = TypeKind.OBJECT;
        }
        return kind;
    }

    public static TypeKind kindOf(Object value) {
        if (value == null) {
            return TypeKind.NULL;
        }
        String typeName = value.getClass().getName();
        TypeKind kind = KINDS.get(typeName);
        if (kind == null) {
            kind = TypeKind.OBJECT;
        }
        return kind;
    }

    public static void setFieldValue(Object instance, String fieldName, Object value) {
        try {
            for (Class<?> c = instance.getClass(); c != Object.class; c = c.getSuperclass()) {
                try {
                    Field field = c.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    field.set(instance, value);
                    field.setAccessible(false);
                    return;
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
            }
        }
        catch (Exception e) {
            throw U.rte("Cannot set field value!", e);
        }
        throw U.rte("Cannot find the field '%s' in the class '%s'", fieldName, instance.getClass());
    }

    public static void setFieldValue(Field field, Object instance, Object value) {
        try {
            field.setAccessible(true);
            field.set(instance, value);
            field.setAccessible(false);
        }
        catch (Exception e) {
            throw U.rte("Cannot set field value!", e);
        }
    }

    public static <T> T getFieldValue(Object instance, String fieldName, T defaultValue) {
        try {
            return (T)Cls.getFieldValue(instance, fieldName);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Object getFieldValue(Object instance, String fieldName) {
        try {
            for (Class<?> c = instance.getClass(); c != Object.class; c = c.getSuperclass()) {
                try {
                    Field field = c.getDeclaredField(fieldName);
                    return Cls.getFieldValue(field, instance);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
        }
        catch (Exception e) {
            throw U.rte("Cannot get field value!", e);
        }
        throw U.rte("Cannot find the field '%s' in the class '%s'", fieldName, instance.getClass());
    }

    public static Object getFieldValue(Field field, Object instance) {
        try {
            field.setAccessible(true);
            Object value = field.get(instance);
            field.setAccessible(false);
            return value;
        }
        catch (Exception e) {
            throw U.rte("Cannot get field value!", e);
        }
    }

    public static List<Annotation> getAnnotations(Class<?> clazz) {
        List<Object> allAnnotations = U.list(new Object[0]);
        try {
            for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
                Annotation[] annotations;
                for (Annotation an : annotations = c.getDeclaredAnnotations()) {
                    allAnnotations.add(an);
                }
            }
        }
        catch (Exception e) {
            throw U.rte("Cannot instantiate class!", e);
        }
        return allAnnotations;
    }

    public static List<Field> getFields(Class<?> clazz) {
        List<Object> allFields = U.list(new Object[0]);
        try {
            for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = c.getDeclaredFields()) {
                    allFields.add(field);
                }
            }
        }
        catch (Exception e) {
            throw U.rte("Cannot instantiate class!", e);
        }
        return allFields;
    }

    public static List<Field> getFieldsAnnotated(Class<?> clazz, Class<? extends Annotation> annotation) {
        List<Object> annotatedFields = U.list(new Object[0]);
        try {
            for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = c.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(annotation)) continue;
                    annotatedFields.add(field);
                }
            }
        }
        catch (Exception e) {
            throw U.rte("Cannot instantiate class!", e);
        }
        return annotatedFields;
    }

    public static List<Method> getMethodsAnnotated(Class<?> clazz, Class<? extends Annotation> annotation) {
        List<Object> annotatedMethods = U.list(new Object[0]);
        try {
            for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
                Method[] methods;
                for (Method method : methods = c.getMethods()) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    annotatedMethods.add(method);
                }
            }
        }
        catch (Exception e) {
            throw U.rte("Cannot instantiate class!", e);
        }
        return annotatedMethods;
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw U.rte("Cannot find method: %s", e, name);
        }
        catch (SecurityException e) {
            throw U.rte("Cannot access method: %s", e, name);
        }
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static <T> T invokeStatic(Method m, Object ... args) {
        boolean accessible = m.isAccessible();
        try {
            m.setAccessible(true);
            Object object = m.invoke(null, args);
            return (T)object;
        }
        catch (IllegalAccessException e) {
            throw U.rte("Cannot statically invoke method '%s' with args: %s", e, m.getName(), Arrays.toString(args));
        }
        catch (IllegalArgumentException e) {
            throw U.rte("Cannot statically invoke method '%s' with args: %s", e, m.getName(), Arrays.toString(args));
        }
        catch (InvocationTargetException e) {
            throw U.rte("Cannot statically invoke method '%s' with args: %s", e, m.getName(), Arrays.toString(args));
        }
        finally {
            m.setAccessible(accessible);
        }
    }

    public static <T> T invoke(Method m, Object target, Object ... args) {
        boolean accessible = m.isAccessible();
        try {
            m.setAccessible(true);
            Object object = m.invoke(target, args);
            return (T)object;
        }
        catch (Exception e) {
            throw U.rte("Cannot invoke method '%s' with args: %s", e, m.getName(), Arrays.toString(args));
        }
        finally {
            m.setAccessible(accessible);
        }
    }

    public static Class<?>[] getImplementedInterfaces(Class<?> clazz) {
        try {
            LinkedList interfaces = new LinkedList();
            for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
                for (Class<?> interf : c.getInterfaces()) {
                    interfaces.add(interf);
                }
            }
            return interfaces.toArray(new Class[interfaces.size()]);
        }
        catch (Exception e) {
            throw U.rte("Cannot retrieve implemented interfaces!", e);
        }
    }

    public static boolean annotatedMethod(Object instance, String methodName, Class<Annotation> annotation) {
        try {
            Method method = instance.getClass().getMethod(methodName, new Class[0]);
            return method.getAnnotation(annotation) != null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... paramTypes) {
        try {
            return clazz.getConstructor(paramTypes);
        }
        catch (Exception e) {
            throw U.rte("Cannot find the constructor for %s with param types: %s", e, clazz, Arrays.toString(paramTypes));
        }
    }

    public static <T> T newInstance(Class<T> clazz, Map<String, Object> properties) {
        if (properties == null) {
            return U.newInstance(clazz);
        }
        Collection<Object> values = properties.values();
        for (Constructor<?> constr : clazz.getConstructors()) {
            Class<?>[] paramTypes = constr.getParameterTypes();
            Object[] args = Cls.getAssignableArgs(paramTypes, values);
            if (args == null) continue;
            try {
                return (T)constr.newInstance(args);
            }
            catch (Exception e) {
                throw U.rte(e);
            }
        }
        throw U.rte("Cannot find appropriate constructor for %s with args %s!", clazz, values);
    }

    private static Object[] getAssignableArgs(Class<?>[] types, Collection<?> properties) {
        Object[] args = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            args[i] = Cls.getUniqueInstanceOf(type, properties);
        }
        return args;
    }

    public static <T> T getUniqueInstanceOf(Class<T> type, Collection<?> values) {
        T instance = null;
        for (Object obj : values) {
            if (!U.instanceOf(obj, type)) continue;
            if (instance == null) {
                instance = (T)obj;
                continue;
            }
            throw U.rte("Found more than one instance of %s: %s and %s", type, instance, obj);
        }
        return instance;
    }

    public static void setId(Object obj, long id) {
        Cls.setPropValue(obj, "id", id);
    }

    public static long getId(Object obj) {
        Long id = Cls.getIdIfExists(obj);
        if (id == null) {
            throw U.rte("The property 'id' cannot be null!");
        }
        return id;
    }

    public static Long getIdIfExists(Object obj) {
        Object id = Cls.getPropValue(obj, "id");
        if (id instanceof Number) {
            return ((Number)id).longValue();
        }
        throw U.rte("The property 'id' must have numeric type, but it has type: " + id.getClass());
    }

    public static long[] getIds(Object ... objs) {
        long[] ids = new long[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            ids[i] = Cls.getId(objs[i]);
        }
        return ids;
    }

    public static void setPropValue(Object instance, String propertyName, Object value) {
        Cls.property(instance, propertyName, true).set(instance, value);
    }

    public static <T> T getPropValue(Object instance, String propertyName, T defaultValue) {
        Prop prop = Cls.property(instance, propertyName, false);
        return prop != null ? prop.get(instance, defaultValue) : defaultValue;
    }

    public static <T> T getPropValue(Object instance, String propertyName) {
        return Cls.property(instance, propertyName, true).get(instance);
    }

    public static Object[] instantiateAll(Class<?> ... classes) {
        Object[] instances = new Object[classes.length];
        for (int i = 0; i < instances.length; ++i) {
            instances[i] = U.newInstance(classes[i]);
        }
        return instances;
    }

    public static Object[] instantiateAll(Collection<Class<?>> classes) {
        if (classes.isEmpty()) {
            return Constants.EMPTY_ARRAY;
        }
        Object[] instances = new Object[classes.size()];
        int i = 0;
        for (Class<?> clazz : classes) {
            instances[i++] = U.newInstance(clazz);
        }
        return instances;
    }

    public static <T> T createProxy(InvocationHandler handler, Class<?> ... interfaces) {
        return (T)Proxy.newProxyInstance(U.classLoader(), interfaces, handler);
    }

    public static <T> T implement(final Object target, final InvocationHandler handler, Class<?> ... interfaces) {
        final Class<?> targetClass = target.getClass();
        return Cls.createProxy(new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().isAssignableFrom(targetClass)) {
                    return method.invoke(target, args);
                }
                return handler.invoke(proxy, method, args);
            }
        }, interfaces);
    }

    public static <T> T implement(InvocationHandler handler, Class<?> ... classes) {
        return Cls.implement(new InterceptorProxy(U.text(classes)), handler, classes);
    }

    public static <T> T implementInterfaces(Object target, InvocationHandler handler) {
        return Cls.implement(target, handler, Cls.getImplementedInterfaces(target.getClass()));
    }

    public static <T> T tracer(Object target) {
        return Cls.implementInterfaces(target, new InvocationHandler(){

            @Override
            public Object invoke(Object target, Method method, Object[] args) throws Throwable {
                U.trace("intercepting", "method", method.getName(), "args", Arrays.toString(args));
                return method.invoke(target, args);
            }
        });
    }

    public static <T> T convert(String value, Class<T> toType) {
        if (value == null) {
            return null;
        }
        if (toType.equals(Object.class)) {
            return (T)value;
        }
        if (Enum.class.isAssignableFrom(toType)) {
            T[] ens;
            for (T t : ens = toType.getEnumConstants()) {
                Enum en = (Enum)t;
                if (!en.name().equalsIgnoreCase(value)) continue;
                return (T)en;
            }
            throw U.rte("Cannot find the enum constant: %s.%s", toType, value);
        }
        TypeKind targetKind = Cls.kindOf(toType);
        switch (targetKind) {
            case NULL: {
                throw U.notExpected();
            }
            case BOOLEAN: 
            case BOOLEAN_OBJ: {
                if ("y".equalsIgnoreCase(value) || "t".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value)) {
                    return (T)Boolean.TRUE;
                }
                if ("n".equalsIgnoreCase(value) || "f".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                    return (T)Boolean.FALSE;
                }
                throw U.rte("Cannot convert the string value '%s' to boolean!", value);
            }
            case BYTE: 
            case BYTE_OBJ: {
                return (T)new Byte(value);
            }
            case SHORT: 
            case SHORT_OBJ: {
                return (T)new Short(value);
            }
            case CHAR: 
            case CHAR_OBJ: {
                return (T)new Character(value.charAt(0));
            }
            case INT: 
            case INT_OBJ: {
                return (T)new Integer(value);
            }
            case LONG: 
            case LONG_OBJ: {
                return (T)new Long(value);
            }
            case FLOAT: 
            case FLOAT_OBJ: {
                return (T)new Float(value);
            }
            case DOUBLE: 
            case DOUBLE_OBJ: {
                return (T)new Double(value);
            }
            case STRING: {
                return (T)value;
            }
            case OBJECT: {
                throw U.rte("Cannot convert string value to type '%s'!", toType);
            }
            case DATE: {
                return (T)Dates.date(value);
            }
        }
        throw U.notExpected();
    }

    public static <T> T convert(Object value, Class<T> toType) {
        if (value == null) {
            return null;
        }
        if (toType.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        if (toType.equals(Object.class)) {
            return (T)value;
        }
        if (value instanceof String) {
            return Cls.convert((String)value, toType);
        }
        TypeKind targetKind = Cls.kindOf(toType);
        boolean isNum = value instanceof Number;
        switch (targetKind) {
            case NULL: {
                throw U.notExpected();
            }
            case BOOLEAN: 
            case BOOLEAN_OBJ: {
                if (value instanceof Boolean) {
                    return (T)value;
                }
                throw U.rte("Cannot convert the value '%s' to boolean!", value);
            }
            case BYTE: 
            case BYTE_OBJ: {
                if (isNum) {
                    return (T)new Byte(((Number)value).byteValue());
                }
                throw U.rte("Cannot convert the value '%s' to byte!", value);
            }
            case SHORT: 
            case SHORT_OBJ: {
                if (isNum) {
                    return (T)new Short(((Number)value).shortValue());
                }
                throw U.rte("Cannot convert the value '%s' to short!", value);
            }
            case CHAR: 
            case CHAR_OBJ: {
                if (isNum) {
                    return (T)new Character((char)((Number)value).intValue());
                }
                throw U.rte("Cannot convert the value '%s' to char!", value);
            }
            case INT: 
            case INT_OBJ: {
                if (isNum) {
                    return (T)new Integer(((Number)value).intValue());
                }
                throw U.rte("Cannot convert the value '%s' to int!", value);
            }
            case LONG: 
            case LONG_OBJ: {
                if (isNum) {
                    return (T)new Long(((Number)value).longValue());
                }
                throw U.rte("Cannot convert the value '%s' to long!", value);
            }
            case FLOAT: 
            case FLOAT_OBJ: {
                if (isNum) {
                    return (T)new Float(((Number)value).floatValue());
                }
                throw U.rte("Cannot convert the value '%s' to float!", value);
            }
            case DOUBLE: 
            case DOUBLE_OBJ: {
                if (isNum) {
                    return (T)new Double(((Number)value).doubleValue());
                }
                throw U.rte("Cannot convert the value '%s' to double!", value);
            }
            case STRING: {
                return (T)U.text(value);
            }
            case OBJECT: {
                throw U.rte("Cannot convert the value to type '%s'!", toType);
            }
            case DATE: {
                if (value instanceof Date) {
                    return (T)value;
                }
                throw U.rte("Cannot convert the value '%s' to date!", value);
            }
        }
        throw U.notExpected();
    }

    public static Map<String, Class<?>> classMap(List<Class<?>> classes) {
        Map<String, Class<?>> map = U.map();
        for (Class<?> cls : classes) {
            map.put(cls.getSimpleName(), cls);
        }
        return map;
    }

    public static Class<?>[] typesOf(Object[] args) {
        Class[] types = new Class[args.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = args[i] != null ? args[i].getClass() : null;
        }
        return types;
    }

    public static Method findMethodByArgs(Class<? extends Object> clazz, String name, Object ... args) {
        for (Method method : clazz.getDeclaredMethods()) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (!method.getName().equals(name) || !U.areAssignable(paramTypes, args)) continue;
            return method;
        }
        return null;
    }
}

