/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.security.SecureClassLoader;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.util.U;

public class CustomizableClassLoader
extends SecureClassLoader {
    private final Mapper<String, byte[]> classes;
    private final Predicate<String> allowed;
    private boolean forceReload;

    public CustomizableClassLoader(Mapper<String, byte[]> classes, Predicate<String> allowed, boolean forceReload) {
        this.classes = classes;
        this.allowed = allowed;
        this.forceReload = forceReload;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        U.secure(U.eval(this.allowed, name), "Class not allowed: %s", name);
        if (this.forceReload && !U.isJREClass(name)) {
            try {
                return this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        U.secure(U.eval(this.allowed, name), "Class not allowed: %s", name);
        byte[] bytes = U.eval(this.classes, name);
        if (bytes != null) {
            return super.defineClass(name, bytes, 0, bytes.length);
        }
        throw new ClassNotFoundException("Cannot find class: " + name);
    }
}

