/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.rapidoid.util.Cls;
import org.rapidoid.util.TypeKind;
import org.rapidoid.util.U;

public class Prop {
    private String name;
    private Field field;
    private Method getter;
    private Method setter;
    private Class<?> type;
    private TypeKind typeKind;
    private Object defaultValue;
    private boolean readOnly = true;

    public void setGetter(Method getter) {
        this.getter = getter;
    }

    public void setSetter(Method setter) {
        this.setter = setter;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public <T> T get(Object obj) {
        try {
            if (this.field != null) {
                this.field.setAccessible(true);
                return (T)this.field.get(obj);
            }
            this.getter.setAccessible(true);
            return (T)this.getter.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw U.rte(e);
        }
    }

    public <T> T get(Object obj, T defaultValue) {
        try {
            if (this.field != null) {
                this.field.setAccessible(true);
                return (T)this.field.get(obj);
            }
            this.getter.setAccessible(true);
            return (T)this.getter.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw U.rte(e);
        }
    }

    public void set(Object obj, Object value) {
        try {
            if (this.field != null) {
                this.field.setAccessible(true);
                this.field.set(obj, this.convert(value, this.getType()));
            } else {
                this.setter.setAccessible(true);
                this.setter.invoke(obj, this.convert(value, this.getType()));
            }
        }
        catch (Exception e) {
            throw U.rte(e);
        }
    }

    private Object convert(Object value, Class<?> toType) {
        if (value == null || toType.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (toType.equals(String.class)) {
            return String.valueOf(value);
        }
        if (value instanceof String) {
            return Cls.convert((String)value, toType);
        }
        return value;
    }

    public Class<?> getType() {
        if (this.type == null) {
            this.type = this.field != null ? this.field.getType() : this.getter.getReturnType();
        }
        return this.type;
    }

    public TypeKind getTypeKind() {
        if (this.typeKind == null) {
            this.typeKind = Cls.kindOf(this.getType());
        }
        return this.typeKind;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String toString() {
        return "Prop [name=" + this.name + ", field=" + this.field + ", getter=" + this.getter + ", setter=" + this.setter + ", type=" + this.type + ", typeKind=" + this.typeKind + ", defaultValue=" + this.defaultValue + ", readOnly=" + this.readOnly + "]";
    }
}

