/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.util.Cls;
import org.rapidoid.util.Constants;
import org.rapidoid.util.F2;
import org.rapidoid.util.TypeKind;
import org.rapidoid.util.U;

public class UTILS
implements Constants {
    private static final Method getGarbageCollectorMXBeans;

    private UTILS() {
    }

    public static byte[] serialize(Object value) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(output);
            out.writeObject(value);
            output.close();
            return output.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object deserialize(byte[] buf) {
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buf));
            Object obj = in.readObject();
            in.close();
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void serialize(Object value, ByteBuffer buf) {
        byte[] bytes = UTILS.serialize(value);
        buf.putInt(bytes.length);
        buf.put(bytes);
    }

    public static Object deserialize(ByteBuffer buf) {
        int len = buf.getInt();
        byte[] bytes = new byte[len];
        buf.get(bytes);
        return UTILS.deserialize(bytes);
    }

    public static void encode(long value, ByteBuffer buf) {
        buf.put((byte)TypeKind.LONG.ordinal());
        buf.putLong(value);
    }

    public static void encode(Object value, ByteBuffer buf) {
        TypeKind kind = Cls.kindOf(value);
        int ordinal = kind.ordinal();
        assert (ordinal < 128);
        byte kindCode = (byte)ordinal;
        buf.put(kindCode);
        switch (kind) {
            case NULL: {
                break;
            }
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                throw U.notExpected();
            }
            case STRING: {
                String str = (String)value;
                byte[] bytes = str.getBytes();
                int len = bytes.length;
                if (len < 255) {
                    buf.put(UTILS.bytee(len));
                } else {
                    buf.put(UTILS.bytee(255));
                    buf.putInt(len);
                }
                buf.put(bytes);
                break;
            }
            case BOOLEAN_OBJ: {
                boolean val = (Boolean)value;
                buf.put((byte)(val ? 1 : 0));
                break;
            }
            case BYTE_OBJ: {
                buf.put((Byte)value);
                break;
            }
            case SHORT_OBJ: {
                buf.putShort((Short)value);
                break;
            }
            case CHAR_OBJ: {
                buf.putChar(((Character)value).charValue());
                break;
            }
            case INT_OBJ: {
                buf.putInt((Integer)value);
                break;
            }
            case LONG_OBJ: {
                buf.putLong((Long)value);
                break;
            }
            case FLOAT_OBJ: {
                buf.putFloat(((Float)value).floatValue());
                break;
            }
            case DOUBLE_OBJ: {
                buf.putDouble((Double)value);
                break;
            }
            case OBJECT: {
                UTILS.serialize(value, buf);
                break;
            }
            case DATE: {
                buf.putLong(((Date)value).getTime());
                break;
            }
            default: {
                throw U.notExpected();
            }
        }
    }

    private static byte bytee(int n) {
        return (byte)(n - 128);
    }

    public static long decodeLong(ByteBuffer buf) {
        U.must(buf.get() == TypeKind.LONG.ordinal());
        return buf.getLong();
    }

    public static Object decode(ByteBuffer buf) {
        byte kindCode = buf.get();
        TypeKind kind = TypeKind.values()[kindCode];
        switch (kind) {
            case NULL: {
                return null;
            }
            case BOOLEAN: 
            case BOOLEAN_OBJ: {
                return buf.get() != 0;
            }
            case BYTE: 
            case BYTE_OBJ: {
                return buf.get();
            }
            case SHORT: 
            case SHORT_OBJ: {
                return buf.getShort();
            }
            case CHAR: 
            case CHAR_OBJ: {
                return Character.valueOf(buf.getChar());
            }
            case INT: 
            case INT_OBJ: {
                return buf.getInt();
            }
            case LONG: 
            case LONG_OBJ: {
                return buf.getLong();
            }
            case FLOAT: 
            case FLOAT_OBJ: {
                return Float.valueOf(buf.getFloat());
            }
            case DOUBLE: 
            case DOUBLE_OBJ: {
                return buf.getDouble();
            }
            case STRING: {
                byte len = buf.get();
                int realLen = len + 128;
                if (realLen == 255) {
                    realLen = buf.getInt();
                }
                byte[] sbuf = new byte[realLen];
                buf.get(sbuf);
                return new String(sbuf);
            }
            case OBJECT: {
                return UTILS.deserialize(buf);
            }
            case DATE: {
                return new Date(buf.getLong());
            }
        }
        throw U.notExpected();
    }

    public static String stackTraceOf(Throwable e) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(output));
        return output.toString();
    }

    public static void connect(String address, int port, F2<Void, BufferedReader, DataOutputStream> protocol) {
        Socket socket = null;
        try {
            socket = new Socket(address, port);
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            protocol.execute(in, out);
            socket.close();
        }
        catch (Exception e) {
            throw U.rte(e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    throw U.rte(e);
                }
            }
        }
    }

    public static void listen(int port, F2<Void, BufferedReader, DataOutputStream> protocol) {
        UTILS.listen(null, port, protocol);
    }

    /*
     * Unable to fully structure code
     */
    public static void listen(String hostname, int port, F2<Void, BufferedReader, DataOutputStream> protocol) {
        socket = null;
        try {
            try {
                socket = new ServerSocket();
                socket.bind(U.isEmpty(hostname) != false ? new InetSocketAddress(port) : new InetSocketAddress(hostname, port));
                U.info("Starting TCP/IP server", "host", hostname, "port", port);
                while (true) lbl-1000:
                // 3 sources

                {
                    conn = socket.accept();
                    in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    out = new DataOutputStream(conn.getOutputStream());
                    try {
                        protocol.execute(in, out);
                    }
                    catch (Exception e) {
                        throw U.rte(e);
                    }
                    finally {
                        conn.close();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw U.rte(e);
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var9_10) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    throw U.rte(e);
                }
            }
            throw var9_10;
        }
    }

    public static void microHttpServer(String hostname, int port, final F2<String, String, List<String>> handler) {
        UTILS.listen(hostname, port, new F2<Void, BufferedReader, DataOutputStream>(){

            @Override
            public Void execute(BufferedReader in, DataOutputStream out) throws Exception {
                String line;
                ArrayList<String> lines = new ArrayList<String>();
                while ((line = in.readLine()) != null && !line.isEmpty()) {
                    lines.add(line);
                }
                if (!lines.isEmpty()) {
                    String req = (String)lines.get(0);
                    if (req.startsWith("GET /")) {
                        int pos = req.indexOf(32, 4);
                        String path = U.urlDecode(req.substring(4, pos));
                        String response = (String)handler.execute(path, lines);
                        out.writeBytes(response);
                    } else {
                        out.writeBytes("Only GET requests are supported!");
                    }
                } else {
                    out.writeBytes("Invalid HTTP request!");
                }
                return null;
            }
        });
    }

    public static <T> void filter(Collection<T> coll, Predicate<T> predicate) {
        try {
            Iterator<T> iterator = coll.iterator();
            while (iterator.hasNext()) {
                T t = iterator.next();
                if (predicate.eval(t)) continue;
                iterator.remove();
            }
        }
        catch (Exception e) {
            throw U.rte(e);
        }
    }

    public static String gcInfo() {
        String gcinfo = "";
        if (getGarbageCollectorMXBeans != null) {
            List gcs = (List)Cls.invokeStatic(getGarbageCollectorMXBeans, new Object[0]);
            for (Object gc : gcs) {
                gcinfo = gcinfo + " | " + Cls.getPropValue(gc, "name") + " x" + Cls.getPropValue(gc, "collectionCount") + ":" + Cls.getPropValue(gc, "collectionTime") + "ms";
            }
        }
        return gcinfo;
    }

    public static short bytesToShort(String s) {
        ByteBuffer buf = U.buf(s);
        U.must(buf.limit() == 2);
        return buf.getShort();
    }

    public static int bytesToInt(String s) {
        ByteBuffer buf = U.buf(s);
        U.must(buf.limit() == 4);
        return buf.getInt();
    }

    public static long bytesToLong(String s) {
        ByteBuffer buf = U.buf(s);
        U.must(buf.limit() == 8);
        return buf.getLong();
    }

    public static int intFrom(byte a, byte b, byte c, byte d) {
        return (a << 24) + (b << 16) + (c << 8) + d;
    }

    public static short shortFrom(byte a, byte b) {
        return (short)((a << 8) + b);
    }

    static {
        Class<?> manFactory = U.getClassIfExists("java.lang.management.ManagementFactory");
        getGarbageCollectorMXBeans = manFactory != null ? Cls.getMethod(manFactory, "getGarbageCollectorMXBeans", new Class[0]) : null;
    }
}

