/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.rapidoid.RapidoidThing;
import org.rapidoid.annotation.OfType;
import org.rapidoid.beany.Metadata;
import org.rapidoid.commons.Arr;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.concurrent.Future;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.http.REST;
import org.rapidoid.lambda.Dynamic;
import org.rapidoid.u.U;
import org.rapidoid.util.Constants;

public class DynamicRESTClient
extends RapidoidThing
implements Dynamic {
    private final Class<?> clientInterface;
    private final Config config;

    public DynamicRESTClient(Class<?> clientInterface) {
        this(clientInterface, Conf.section(clientInterface));
    }

    public DynamicRESTClient(Class<?> clientInterface, Config config) {
        this.clientInterface = clientInterface;
        this.config = config;
    }

    public Object call(Method m, Object[] args) {
        U.must((!this.config.isEmpty() ? 1 : 0) != 0, (String)"Cannot find configuration for the REST client interface: %s", (Object)this.clientInterface.getSimpleName());
        Config cfg = this.config.sub(new String[]{m.getName()});
        String verb = this.verbOf(cfg);
        String url = (String)cfg.entry(verb).str().get();
        U.must((!U.isEmpty((String)verb) ? 1 : 0) != 0, (String)"The [verb: url] entry is not configured for the method: %s", (Object)m);
        U.must((!U.isEmpty((String)url) ? 1 : 0) != 0, (String)"Cannot find 'url' configuration for the method: %s", (Object)m);
        Class<?> retType = m.getReturnType();
        Object[] paramTypes = m.getParameterTypes();
        Class lastParamType = (Class)U.last((Object[])paramTypes);
        if (lastParamType != null && Callback.class.isAssignableFrom(lastParamType)) {
            U.must((retType.equals(Void.TYPE) || java.util.concurrent.Future.class.isAssignableFrom(retType) || Future.class.isAssignableFrom(retType) ? 1 : 0) != 0);
            Callback callback = (Callback)U.last((Object[])args);
            U.notNull((Object)callback, (String)"callback", (Object[])new Object[0]);
            args = Arr.sub((Object[])args, (int)0, (int)-1);
            String realUrl = String.format(url, args);
            OfType ofType = (OfType)Metadata.get((Annotation[])((Annotation[])U.last((Object[])m.getParameterAnnotations())), OfType.class);
            Class resultType = ofType != null ? ofType.value() : Object.class;
            return REST.call(verb, realUrl, resultType, callback);
        }
        String realUrl = String.format(url, args);
        return REST.call(verb, realUrl, retType);
    }

    private String verbOf(Config cfg) {
        for (String verb : Constants.HTTP_VERBS) {
            if (!cfg.has(verb)) continue;
            return verb;
        }
        return null;
    }
}

