/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.ddi;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.rapidpm.ddi.DDIModelException;
import org.rapidpm.ddi.bootstrap.ClassResolverCheck001;
import org.rapidpm.ddi.implresolver.ImplementingClassResolver;
import org.rapidpm.ddi.producer.InstanceCreator;
import org.rapidpm.ddi.producer.ProducerLocator;
import org.rapidpm.ddi.reflections.ReflectionsModel;
import org.rapidpm.ddi.scopes.InjectionScopeManager;
import org.rapidpm.dependencies.core.logger.Logger;
import org.rapidpm.dependencies.core.logger.LoggingService;

public class DI {
    private static final LoggingService LOGGER = Logger.getLogger(DI.class);
    public static final String ORG_RAPIDPM_DDI_PACKAGESFILE = "org.rapidpm.ddi.packagesfile";
    private static ReflectionsModel reflectionsModel = new ReflectionsModel();
    private static boolean bootstrapedNeeded = true;

    private DI() {
    }

    public static void checkActiveModel() {
        new ClassResolverCheck001().execute();
    }

    public static synchronized void bootstrap() {
        ImplementingClassResolver.clearCache();
        if (bootstrapedNeeded) {
            String packageFilePath = System.getProperty(ORG_RAPIDPM_DDI_PACKAGESFILE);
            if (packageFilePath != null && !packageFilePath.isEmpty()) {
                DI.bootstrapFromResource(packageFilePath);
            } else {
                reflectionsModel.rescann("");
            }
        }
        bootstrapedNeeded = false;
    }

    private static void bootstrapFromResource(String path) {
        try (InputStream is = ClassLoader.getSystemResourceAsStream(path);){
            DI.loadJarResource(is);
        }
        catch (IOException e) {
            DI.loadFilesystemResource(path, e);
        }
    }

    private static void loadFilesystemResource(String path, IOException e) {
        try (FileInputStream is = new FileInputStream(path);){
            DI.bootstrapFromResource(is);
        }
        catch (IOException e1) {
            LOGGER.warning(String.format("Error loading file <%s> <%s>", path, e.getMessage()));
            throw new DDIModelException("Unable to load packages from file", e1);
        }
    }

    private static void loadJarResource(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException();
        }
        DI.bootstrapFromResource(is);
    }

    private static void bootstrapFromResource(InputStream inputStream) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                reflectionsModel.rescann(line);
            }
        }
        catch (IOException e) {
            LOGGER.warning(String.format("Error loading packages", new Object[0]));
            throw new DDIModelException("Unable to load packages from file", e);
        }
    }

    public static synchronized void clearReflectionModel() {
        reflectionsModel = new ReflectionsModel();
        DI.clearCaches();
        InjectionScopeManager.reInitAllScopes();
        bootstrapedNeeded = true;
    }

    private static void clearCaches() {
        ImplementingClassResolver.clearCache();
        ProducerLocator.clearCache();
        InjectionScopeManager.cleanUp();
        reflectionsModel.clearCaches();
    }

    public static synchronized void activatePackages(Class clazz) {
        reflectionsModel.rescann(clazz.getPackage().getName());
        DI.clearCaches();
        bootstrapedNeeded = false;
    }

    public static synchronized void activatePackages(String pkg) {
        reflectionsModel.rescann(pkg);
        DI.clearCaches();
        bootstrapedNeeded = false;
    }

    public static synchronized void activatePackages(String pkg, URL ... urls) {
        reflectionsModel.rescann(pkg, urls);
        DI.clearCaches();
        bootstrapedNeeded = false;
    }

    public static synchronized void activatePackages(String pkg, Collection<URL> urls) {
        reflectionsModel.rescann(pkg, urls);
        DI.clearCaches();
        bootstrapedNeeded = false;
    }

    public static synchronized <T> T activateDI(T instance) {
        if (bootstrapedNeeded) {
            DI.bootstrap();
        }
        DI.injectAttributes(instance);
        DI.initialize(instance);
        return instance;
    }

    public static synchronized <T> T activateDI(Class<T> clazz2Instanciate) {
        if (bootstrapedNeeded) {
            DI.bootstrap();
        }
        T instance = new InstanceCreator().instantiate(clazz2Instanciate);
        DI.injectAttributes(instance);
        DI.initialize(instance);
        return instance;
    }

    public static Set<String> listAllActiveScopes() {
        return InjectionScopeManager.listAllActiveScopeNames();
    }

    public static void registerClassForScope(Class clazz, String scope) {
        InjectionScopeManager.registerClassForScope(clazz, scope);
    }

    public static void deRegisterClassForScope(Class clazz) {
        InjectionScopeManager.deRegisterClassForScope(clazz);
    }

    private static <T> void injectAttributes(T rootInstance) throws SecurityException {
        DI.injectAttributesForClass(rootInstance.getClass(), rootInstance);
    }

    private static <T> void injectAttributesForClass(Class targetClass, T rootInstance) {
        Field[] fields;
        Class superclass = targetClass.getSuperclass();
        if (superclass != null) {
            DI.injectAttributesForClass(superclass, rootInstance);
        }
        for (Field field : fields = targetClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            Class<?> targetType = field.getType();
            Object value = new InstanceCreator().instantiate(targetType);
            DI.activateDI(value);
            if (value == null) continue;
            DI.injectIntoField(field, rootInstance, value);
        }
    }

    private static void injectIntoField(Field field, Object instance, Object target) {
        AccessController.doPrivileged(() -> {
            boolean wasAccessible = field.isAccessible();
            field.setAccessible(true);
            try {
                field.set(instance, target);
                Object var4_4 = null;
                return var4_4;
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                LOGGER.warning("Cannot set field: ", ex);
                throw new IllegalStateException("Cannot set field: " + field, ex);
            }
            finally {
                field.setAccessible(wasAccessible);
            }
        });
    }

    private static void initialize(Object instance) {
        Class<?> clazz = instance.getClass();
        DI.invokeMethodWithAnnotation(clazz, instance, PostConstruct.class);
    }

    private static void invokeMethodWithAnnotation(Class clazz, Object instance, Class<? extends Annotation> annotationClass) throws IllegalStateException, SecurityException {
        Set<Method> methodsAnnotatedWith = reflectionsModel.getMethodsAnnotatedWith(clazz, (Annotation)new PostConstruct(){

            public Class<? extends Annotation> annotationType() {
                return PostConstruct.class;
            }
        });
        methodsAnnotatedWith.forEach(m -> {
            try {
                boolean accessible = m.isAccessible();
                m.setAccessible(true);
                m.invoke(instance, new Object[0]);
                m.setAccessible(accessible);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warning("method could not invoked ", e);
            }
        });
    }

    public static <T> Class<? extends T> resolveImplementingClass(Class<T> interf) {
        return ImplementingClassResolver.resolve(interf);
    }

    public static boolean isPkgPrefixActivated(String pkgPrefix) {
        return reflectionsModel.isPkgPrefixActivated(pkgPrefix);
    }

    public static boolean isPkgPrefixActivated(Class clazz) {
        return reflectionsModel.isPkgPrefixActivated(clazz.getPackage().getName());
    }

    public static LocalDateTime getPkgPrefixActivatedTimestamp(String pkgPrefix) {
        return reflectionsModel.getPkgPrefixActivatedTimestamp(pkgPrefix);
    }

    public static <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        return reflectionsModel.getSubTypesOf(type);
    }

    public static <T> Set<Class<? extends T>> getSubTypesWithoutInterfacesAndGeneratedOf(Class<T> type) {
        return reflectionsModel.getSubTypesWithoutInterfacesAndGeneratedOf(type);
    }

    public static Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        return reflectionsModel.getTypesAnnotatedWith(annotation);
    }

    public static Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation, boolean honorInherited) {
        return reflectionsModel.getTypesAnnotatedWith(annotation, honorInherited);
    }

    public static Set<Class<?>> getTypesAnnotatedWith(Annotation annotation) {
        return reflectionsModel.getTypesAnnotatedWith(annotation);
    }

    public static Set<Class<?>> getTypesAnnotatedWith(Annotation annotation, boolean honorInherited) {
        return reflectionsModel.getTypesAnnotatedWith(annotation, honorInherited);
    }
}

