/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.ddi.implresolver;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.rapidpm.ddi.DDIModelException;
import org.rapidpm.ddi.DI;
import org.rapidpm.ddi.ResponsibleFor;
import org.rapidpm.ddi.implresolver.ClassResolver;
import org.rapidpm.ddi.producer.ProducerLocator;
import org.rapidpm.dependencies.core.logger.Logger;
import org.rapidpm.dependencies.core.logger.LoggingService;

public class ImplementingClassResolver {
    private static final LoggingService LOGGER = Logger.getLogger(ImplementingClassResolver.class);
    private static final ImplementingClassResolver INSTANCE = new ImplementingClassResolver();
    private final Map<Class, Class<? extends ClassResolver>> resolverCacheForClass2ClassResolver = new ConcurrentHashMap<Class, Class<? extends ClassResolver>>();

    public static void clearCache() {
        ImplementingClassResolver.INSTANCE.resolverCacheForClass2ClassResolver.clear();
    }

    public static <I> Class<? extends I> resolve(Class<I> interf) {
        return INSTANCE.resolveNewForClass(interf);
    }

    private <I> Class<? extends I> resolveNewForClass(Class<I> interf) {
        if (interf.isInterface()) {
            Set<Class<I>> subTypesOf = DI.getSubTypesWithoutInterfacesAndGeneratedOf(interf);
            if (subTypesOf.isEmpty()) {
                return interf;
            }
            if (subTypesOf.size() == 1) {
                return this.handleOneSubType(interf, subTypesOf.toArray()[0]);
            }
            return this.handleManySubTypes(interf, subTypesOf);
        }
        return interf;
    }

    private <I> Class<? extends I> handleOneSubType(Class<I> interf, Object o) {
        Class implClass = (Class)o;
        Set<Class<?>> producersForInterface = ProducerLocator.findProducersFor(interf);
        Set<Class<?>> producersForImpl = ProducerLocator.findProducersFor(implClass);
        if (!producersForInterface.isEmpty() && !producersForImpl.isEmpty()) {
            return interf;
        }
        if (producersForInterface.isEmpty() && producersForImpl.isEmpty()) {
            return implClass;
        }
        if (producersForImpl.isEmpty()) {
            return interf;
        }
        if (producersForInterface.isEmpty()) {
            return implClass;
        }
        return null;
    }

    private <I> Class<? extends I> handleManySubTypes(Class<I> interf, Set<Class<? extends I>> subTypesOf) {
        if (this.resolverCacheForClass2ClassResolver.containsKey(interf)) {
            return this.handleOneResolver(interf, this.resolverCacheForClass2ClassResolver.get(interf));
        }
        List clearedListOfResolvers = DI.getSubTypesWithoutInterfacesAndGeneratedOf(ClassResolver.class).stream().filter(aClassResolver -> aClassResolver.isAnnotationPresent(ResponsibleFor.class)).filter(aClassResolver -> {
            ResponsibleFor responsibleFor = aClassResolver.getAnnotation(ResponsibleFor.class);
            return interf.equals(responsibleFor.value());
        }).collect(Collectors.toList());
        if (clearedListOfResolvers.size() == 1) {
            Class classResolverClass = (Class)clearedListOfResolvers.get(0);
            this.resolverCacheForClass2ClassResolver.put(interf, classResolverClass);
            return this.handleOneResolver(interf, classResolverClass);
        }
        if (clearedListOfResolvers.isEmpty()) {
            return this.handleNoResolvers(interf, subTypesOf);
        }
        String message = "interface with multiple implementations and more as 1 ClassResolver = " + interf + " ClassResolver: " + clearedListOfResolvers;
        throw new DDIModelException(message);
    }

    private <I> Class<? extends I> handleOneResolver(Class<I> interf, Class<? extends ClassResolver> classResolverClass) {
        try {
            ClassResolver classResolver = classResolverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return classResolver.resolve(interf);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            LOGGER.warning("could not create instance ", e);
            throw new DDIModelException(interf + " -- " + e);
        }
        catch (InvocationTargetException e) {
            LOGGER.warning("could not create instance ", e);
            throw new DDIModelException(interf + " -- " + e);
        }
    }

    private <I> Class<? extends I> handleNoResolvers(Class<I> interf, Set<Class<? extends I>> subTypesOf) {
        Set<Class<?>> producersForInterface = ProducerLocator.findProducersFor(interf);
        if (producersForInterface.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("interface with multiple implementations and no ClassResolver= " + interf);
            List implList = subTypesOf.stream().map(c -> "impl. : " + c.getName()).collect(Collectors.toList());
            stringBuilder.append(implList);
            throw new DDIModelException(stringBuilder.toString());
        }
        if (producersForInterface.size() == 1) {
            return interf;
        }
        StringBuilder stringBuilder = new StringBuilder("interface with multiple implementations and no ClassResolver and n Producers f the interface = " + interf);
        List implList = subTypesOf.stream().map(c -> "impl. : " + c.getName()).collect(Collectors.toList());
        List prodList = producersForInterface.stream().map(c -> "producer. : " + c.getName()).collect(Collectors.toList());
        stringBuilder.append(implList).append(prodList);
        throw new DDIModelException(stringBuilder.toString());
    }
}

