/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.ddi.producer;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.rapidpm.ddi.DDIModelException;
import org.rapidpm.ddi.DI;
import org.rapidpm.ddi.producer.Producer;
import org.rapidpm.ddi.producer.ProducerLocator;
import org.rapidpm.ddi.producerresolver.ProducerResolver;
import org.rapidpm.ddi.producerresolver.ProducerResolverLocator;
import org.rapidpm.ddi.scopes.InjectionScopeManager;
import org.rapidpm.dependencies.core.logger.Logger;
import org.rapidpm.dependencies.core.logger.LoggingService;

public class InstanceCreator {
    private static final LoggingService LOGGER = Logger.getLogger(InstanceCreator.class);

    public <T> T instantiate(Class<T> clazz) {
        T newInstance;
        if (clazz.isInterface()) {
            Class<T> resolve = DI.resolveImplementingClass(clazz);
            newInstance = this.createNewInstance(clazz, resolve);
        } else {
            newInstance = this.createNewInstance(clazz, clazz);
        }
        return newInstance;
    }

    private <T> T createNewInstance(Class classOrInterf, Class clazz) {
        Object cast;
        Class resolverTarget = classOrInterf.isInterface() && !clazz.isInterface() ? clazz : (!classOrInterf.isInterface() && clazz.isInterface() ? classOrInterf : (!classOrInterf.isInterface() && !clazz.isInterface() ? classOrInterf : classOrInterf));
        boolean managedByMeTarget = InjectionScopeManager.isManagedByMe(classOrInterf);
        boolean managedByMeImpl = InjectionScopeManager.isManagedByMe(resolverTarget);
        if (managedByMeTarget ? (cast = InjectionScopeManager.getInstance(classOrInterf)) != null : managedByMeImpl && (cast = InjectionScopeManager.getInstance(resolverTarget)) != null) {
            return cast;
        }
        Set<Class<?>> producerClassses = ProducerLocator.findProducersFor(classOrInterf);
        if (producerClassses.size() == 1) {
            Class cls = (Class)producerClassses.toArray()[0];
            T result = this.createInstanceWithThisProducer(cls);
            this.putToScope(classOrInterf, clazz, managedByMeTarget, managedByMeImpl, result);
            return result;
        }
        if (producerClassses.size() > 1) {
            return this.createInstanceWithProducers(classOrInterf, clazz, resolverTarget, managedByMeTarget, managedByMeImpl, producerClassses);
        }
        if (producerClassses.isEmpty()) {
            if (clazz.isInterface()) {
                throw new DDIModelException(" only interfaces found for " + classOrInterf);
            }
            try {
                Object result;
                Set<Class<?>> producersForImpl = ProducerLocator.findProducersFor(clazz);
                if (producersForImpl.isEmpty()) {
                    result = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else if (producersForImpl.size() > 1) {
                    Set<Class<? extends ProducerResolver>> producerResolverClasses = new ProducerResolverLocator().findProducersResolverFor(resolverTarget);
                    if (producerResolverClasses.size() > 1) {
                        throw new DDIModelException("to many producersResolver for Impl " + clazz + " - > " + producerResolverClasses);
                    }
                    if (producerResolverClasses.isEmpty()) {
                        throw new DDIModelException("no producersResolver for Impl " + clazz + " and n Producers - > " + producersForImpl);
                    }
                    Class producerResolverClass = (Class)producerResolverClasses.toArray()[0];
                    ProducerResolver producerResolver = (ProducerResolver)producerResolverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Class producerClass = producerResolver.resolve(clazz);
                    Producer tProducer = producerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    DI.activateDI(tProducer);
                    result = tProducer.create();
                } else {
                    Class producerClass = (Class)producersForImpl.toArray()[0];
                    Producer tProducer = (Producer)producerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    DI.activateDI(tProducer);
                    result = tProducer.create();
                }
                this.putToScope(classOrInterf, clazz, managedByMeTarget, managedByMeImpl, result);
                return result;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new DDIModelException(e);
            }
        }
        throw new RuntimeException("this point should never reached...");
    }

    private <T> T createInstanceWithThisProducer(Class cls) {
        try {
            Producer producer = (Producer)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DI.activateDI(producer);
            Object instance = producer.create();
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warning("could not create instance ", e);
            throw new DDIModelException(e);
        }
    }

    private <T> void putToScope(Class classOrInterf, Class clazz, boolean managedByMeTarget, boolean managedByMeImpl, T result) {
        if (managedByMeTarget && managedByMeImpl) {
            InjectionScopeManager.manageInstance(classOrInterf, result);
        } else if (managedByMeTarget) {
            InjectionScopeManager.manageInstance(classOrInterf, result);
        } else if (managedByMeImpl) {
            InjectionScopeManager.manageInstance(clazz, result);
        }
    }

    private <T> T createInstanceWithProducers(Class classOrInterf, Class clazz, Class resolverTarget, boolean managedByMeTarget, boolean managedByMeImpl, Set<Class<?>> producerClassses) {
        Set<Class<? extends ProducerResolver>> producerResolverClasses = new ProducerResolverLocator().findProducersResolverFor(resolverTarget);
        if (producerResolverClasses.size() == 1) {
            Class producerResolverClass = (Class)producerResolverClasses.toArray()[0];
            try {
                ProducerResolver producerResolver = (ProducerResolver)producerResolverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                DI.activateDI(producerResolver);
                T result = this.createInstanceWithThisProducer(producerResolver.resolve(resolverTarget));
                this.putToScope(classOrInterf, clazz, managedByMeTarget, managedByMeImpl, result);
                return result;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new DDIModelException(e);
            }
        }
        if (producerResolverClasses.size() > 1) {
            throw new DDIModelException("toooo many ProducerResolver for interface/class " + resolverTarget + " - " + producerResolverClasses);
        }
        throw new DDIModelException(" to many Producer and no ProducerResolver found for " + classOrInterf + " - " + producerClassses);
    }
}

