/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.ddi.producer;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.rapidpm.ddi.DI;
import org.rapidpm.ddi.Produces;

public class ProducerLocator {
    private static final Map<Class, Set<Class<?>>> RESOLVER_CACHE_FOR_CLASS_2_PRODUCER_SET = new ConcurrentHashMap();

    private ProducerLocator() {
    }

    public static void clearCache() {
        RESOLVER_CACHE_FOR_CLASS_2_PRODUCER_SET.clear();
    }

    public static Set<Class<?>> findProducersFor(Class clazzOrInterf) {
        if (RESOLVER_CACHE_FOR_CLASS_2_PRODUCER_SET.containsKey(clazzOrInterf)) {
            return RESOLVER_CACHE_FOR_CLASS_2_PRODUCER_SET.get(clazzOrInterf);
        }
        Set typesAnnotatedWith = DI.getTypesAnnotatedWith(Produces.class).stream().filter(producerClass -> {
            Produces annotation = producerClass.getAnnotation(Produces.class);
            Class value = annotation.value();
            return value.equals(clazzOrInterf);
        }).collect(Collectors.toSet());
        Set<Class<?>> unmodifiableSet = Collections.unmodifiableSet(typesAnnotatedWith);
        RESOLVER_CACHE_FOR_CLASS_2_PRODUCER_SET.put(clazzOrInterf, unmodifiableSet);
        return unmodifiableSet;
    }
}

