/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.ddi.reflections;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Set;
import org.rapidpm.dependencies.core.stream.ImmutableSetCollector;

public class ReflectionUtils
extends org.reflections.ReflectionUtils {
    public boolean checkInterface(Type aClass, Class targetInterface) {
        Type[] genericInterfaces;
        if (aClass.equals(targetInterface)) {
            return true;
        }
        for (Type genericInterface : genericInterfaces = ((Class)aClass).getGenericInterfaces()) {
            Type[] nextLevBackArray;
            if (genericInterface.equals(targetInterface)) {
                return true;
            }
            for (Type type : nextLevBackArray = ((Class)genericInterface).getGenericInterfaces()) {
                if (!this.checkInterface(type, targetInterface)) continue;
                return true;
            }
        }
        Type genericSuperclass = ((Class)aClass).getGenericSuperclass();
        return genericSuperclass != null && this.checkInterface(genericSuperclass, targetInterface);
    }

    public <T> Set<Class<? extends T>> removeInterfacesAndGeneratedFromSubTypes(Set<Class<? extends T>> subTypesOf) {
        return subTypesOf.stream().filter(c -> !c.isInterface()).filter(c -> !Modifier.isAbstract(c.getModifiers())).collect(ImmutableSetCollector.toImmutableSet());
    }
}

