/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.ddi.reflections;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.rapidpm.ddi.reflections.PkgTypesScanner;
import org.rapidpm.ddi.reflections.ReflectionUtils;
import org.rapidpm.frp.model.Pair;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class ReflectionsModel {
    private final Map<String, LocalDateTime> activatedPackagesMap = new ConcurrentHashMap<String, LocalDateTime>();
    private final Object obj = new Object();
    private final Map<Pair<String, String>, Set<Method>> methodsAnnotatedWithCache = new ConcurrentHashMap<Pair<String, String>, Set<Method>>();
    private final Map<String, Set> subTypeOfCache = new ConcurrentHashMap<String, Set>();
    private final Map<String, Set> subTypeOfCacheWithoutInterfacesnadGenerated = new ConcurrentHashMap<String, Set>();
    private final Map<Class<? extends Annotation>, Set> typesAnnotatedWithCache = new ConcurrentHashMap<Class<? extends Annotation>, Set>();
    private boolean parallelExecutors;
    private final Reflections reflections = new Reflections(this.createConfigurationBuilder().filterInputsBy(new FilterBuilder().include(FilterBuilder.prefix("org.rapidpm"))).setScanners(this.createScanners()));
    private final Function<Set, Set> newSet = input -> {
        HashSet hashSet = new HashSet();
        hashSet.addAll(input);
        return hashSet;
    };

    public void setParallelExecutors(boolean parallelExecutors) {
        this.parallelExecutors = parallelExecutors;
    }

    public void rescann(String pkgPrefix) {
        this.rescannImpl(this.createConfigurationBuilder().filterInputsBy(new FilterBuilder().include(FilterBuilder.prefix(pkgPrefix))).setScanners(this.createScanners()));
        this.activatedPackagesMap.put(pkgPrefix, LocalDateTime.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescannImpl(ConfigurationBuilder configuration) {
        Object object = this.obj;
        synchronized (object) {
            LocalDateTime now = LocalDateTime.now();
            Reflections reflections = new Reflections(configuration);
            this.reflections.merge(reflections);
            this.refreshActivatedPkgMap(now, reflections);
            this.clearCaches();
        }
    }

    private ConfigurationBuilder createConfigurationBuilder() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.setUrls(ClasspathHelper.forJavaClassPath());
        if (this.parallelExecutors) {
            return configurationBuilder.useParallelExecutor();
        }
        return configurationBuilder;
    }

    private Scanner[] createScanners() {
        Scanner[] sccannerArray = new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner(), new MethodAnnotationsScanner(), new PkgTypesScanner()};
        return sccannerArray;
    }

    private void refreshActivatedPkgMap(LocalDateTime now, Reflections reflections) {
        reflections.getStore().get(this.index(PkgTypesScanner.class)).keySet().forEach(pkgName -> this.activatedPackagesMap.put((String)pkgName, now));
    }

    public void clearCaches() {
        this.methodsAnnotatedWithCache.clear();
        this.subTypeOfCache.clear();
        this.subTypeOfCacheWithoutInterfacesnadGenerated.clear();
        this.typesAnnotatedWithCache.clear();
    }

    private String index(Class clazz) {
        return clazz.getSimpleName();
    }

    public void rescann(String pkgPrefix, URL ... urls) {
        this.rescannImpl(this.createConfigurationBuilder().filterInputsBy(new FilterBuilder().include(FilterBuilder.prefix(pkgPrefix))).setUrls(urls).setScanners(this.createScanners()));
        this.activatedPackagesMap.put(pkgPrefix, LocalDateTime.now());
    }

    public void rescann(String pkgPrefix, Collection<URL> urls) {
        this.rescannImpl(this.createConfigurationBuilder().filterInputsBy(new FilterBuilder().include(FilterBuilder.prefix(pkgPrefix))).setUrls(urls).setScanners(this.createScanners()));
        this.activatedPackagesMap.put(pkgPrefix, LocalDateTime.now());
    }

    public Set<String> getActivatedPkgs() {
        return new HashSet<String>(this.activatedPackagesMap.keySet());
    }

    public boolean isPkgPrefixActivated(String pkgPrefix) {
        return this.activatedPackagesMap.containsKey(pkgPrefix);
    }

    public LocalDateTime getPkgPrefixActivatedTimestamp(String pkgPrefix) {
        return this.activatedPackagesMap.getOrDefault(pkgPrefix, LocalDateTime.MIN);
    }

    public Collection<String> getClassesForPkg(String pkgName) {
        Collection<String> clsNames = this.reflections.getStore().get(this.index(PkgTypesScanner.class)).get(pkgName);
        return Collections.unmodifiableCollection(clsNames);
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        if (this.subTypeOfCache.containsKey(type.getName())) {
            return this.subTypeOfCache.get(type.getName());
        }
        Set<Class<? extends T>> subTypesOf = this.reflections.getSubTypesOf(type);
        this.subTypeOfCache.put(type.getName(), subTypesOf);
        return subTypesOf;
    }

    public <T> Set<Class<? extends T>> getSubTypesWithoutInterfacesAndGeneratedOf(Class<T> type) {
        if (this.subTypeOfCacheWithoutInterfacesnadGenerated.containsKey(type.getName())) {
            return this.subTypeOfCacheWithoutInterfacesnadGenerated.get(type.getName());
        }
        Set subTypesOf = this.reflections.getSubTypesOf(type);
        Set unmodifiableSet = new ReflectionUtils().removeInterfacesAndGeneratedFromSubTypes(subTypesOf);
        this.subTypeOfCacheWithoutInterfacesnadGenerated.put(type.getName(), unmodifiableSet);
        return unmodifiableSet;
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        if (this.typesAnnotatedWithCache.containsKey(annotation)) {
            return this.typesAnnotatedWithCache.get(annotation);
        }
        Set<Class<?>> typesAnnotatedWith = Collections.unmodifiableSet(this.reflections.getTypesAnnotatedWith(annotation));
        this.typesAnnotatedWithCache.put(annotation, typesAnnotatedWith);
        return typesAnnotatedWith;
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation, boolean honorInherited) {
        return this.reflections.getTypesAnnotatedWith(annotation, honorInherited);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation) {
        return this.reflections.getTypesAnnotatedWith(annotation);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation, boolean honorInherited) {
        return this.reflections.getTypesAnnotatedWith(annotation, honorInherited);
    }

    public Set<Method> getMethodsAnnotatedWith(Class clazz, Annotation annotation) {
        Pair<String, String> key = new Pair<String, String>(clazz.getName(), annotation.annotationType().getName());
        if (this.methodsAnnotatedWithCache.containsKey(key)) {
            return this.methodsAnnotatedWithCache.get(key);
        }
        Set<Method> allMethods = ReflectionUtils.getAllMethods(clazz, input -> input != null && input.isAnnotationPresent(annotation.annotationType()));
        Set<Method> unmodifiableSet = Collections.unmodifiableSet(allMethods);
        this.methodsAnnotatedWithCache.put(key, unmodifiableSet);
        return unmodifiableSet;
    }
}

