/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.ddi.scopes;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.rapidpm.ddi.DI;
import org.rapidpm.ddi.scopes.InjectionScope;
import org.rapidpm.dependencies.core.logger.Logger;
import org.rapidpm.dependencies.core.logger.LoggingService;

public class InjectionScopeManager {
    private static final LoggingService LOGGER = Logger.getLogger(InjectionScopeManager.class);
    private static final Map<String, String> CLASS_NAME_2_SCOPENAME_MAP = new ConcurrentHashMap<String, String>();
    private static final Map<String, InjectionScope> INJECTION_SCOPE_MAP = new ConcurrentHashMap<String, InjectionScope>();

    private InjectionScopeManager() {
    }

    public static <T> T getInstance(Class<T> target) {
        String targetName = target.getName();
        if (CLASS_NAME_2_SCOPENAME_MAP.containsKey(targetName)) {
            InjectionScope injectionScope = INJECTION_SCOPE_MAP.get(CLASS_NAME_2_SCOPENAME_MAP.get(targetName));
            return injectionScope.getInstance(targetName);
        }
        return null;
    }

    public static <T> void manageInstance(Class<T> targetClass, T instance) {
        String targetName = targetClass.getName();
        if (CLASS_NAME_2_SCOPENAME_MAP.containsKey(targetName)) {
            InjectionScope injectionScope = INJECTION_SCOPE_MAP.get(CLASS_NAME_2_SCOPENAME_MAP.get(targetName));
            injectionScope.storeInstance(targetClass, instance);
        }
    }

    public static boolean isManagedByMe(Class clazz) {
        return CLASS_NAME_2_SCOPENAME_MAP.containsKey(clazz.getName());
    }

    public static synchronized void cleanUp() {
        Set<Class<? extends InjectionScope>> scopesFromReflectionModel = DI.getSubTypesOf(InjectionScope.class);
        InjectionScopeManager.registerNewScopes(scopesFromReflectionModel);
        InjectionScopeManager.removeOldScopes(scopesFromReflectionModel);
    }

    private static void registerNewScopes(Set<Class<? extends InjectionScope>> scopeClasses) {
        scopeClasses.stream().map(c -> {
            try {
                return (InjectionScope)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.warning("could not create an instance ", e);
                return null;
            }
        }).filter(Objects::nonNull).filter(scope -> !INJECTION_SCOPE_MAP.containsKey(scope.getScopeName())).forEach(injectionScope -> INJECTION_SCOPE_MAP.put(injectionScope.getScopeName(), (InjectionScope)injectionScope));
    }

    private static void removeOldScopes(Set<Class<? extends InjectionScope>> scopeClasses) {
        Set<String> scopeNamesFromReflectionModel = InjectionScopeManager.getNamesFromScopes(scopeClasses);
        INJECTION_SCOPE_MAP.keySet().stream().filter(scope -> !scopeNamesFromReflectionModel.contains(scope)).forEach(InjectionScopeManager::removeScope);
    }

    private static Set<String> getNamesFromScopes(Set<Class<? extends InjectionScope>> scopes) {
        return scopes.stream().map(c -> {
            try {
                return (InjectionScope)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.warning("could not create new instance ", e);
                return null;
            }
        }).filter(Objects::nonNull).map(InjectionScope::getScopeName).collect(Collectors.toSet());
    }

    public static void registerClassForScope(Class clazz, String scopeName) {
        if (INJECTION_SCOPE_MAP.containsKey(scopeName)) {
            CLASS_NAME_2_SCOPENAME_MAP.putIfAbsent(clazz.getName(), scopeName);
        }
    }

    public static void deRegisterClassForScope(Class clazz) {
        if (CLASS_NAME_2_SCOPENAME_MAP.containsKey(clazz.getName())) {
            CLASS_NAME_2_SCOPENAME_MAP.remove(clazz.getName());
        }
    }

    public static String scopeForClass(Class clazz) {
        String clazzName = clazz.getName();
        return CLASS_NAME_2_SCOPENAME_MAP.getOrDefault(clazzName, "PER INJECT");
    }

    public static Set<String> listAllActiveScopeNames() {
        return Collections.unmodifiableSet(INJECTION_SCOPE_MAP.keySet());
    }

    public static void clearScope(String scopeName) {
        INJECTION_SCOPE_MAP.computeIfPresent(scopeName, (s, injectionScope) -> {
            injectionScope.clear();
            return injectionScope;
        });
    }

    private static void removeScope(String scopeName) {
        Set<String> keySet = CLASS_NAME_2_SCOPENAME_MAP.keySet();
        INJECTION_SCOPE_MAP.computeIfPresent(scopeName, (s, injectionScope) -> {
            injectionScope.clear();
            keySet.forEach(k -> CLASS_NAME_2_SCOPENAME_MAP.computeIfPresent((String)k, (classname, scope) -> scope.equals(scopeName) ? null : scope));
            return null;
        });
    }

    public static void reInitAllScopes() {
        CLASS_NAME_2_SCOPENAME_MAP.clear();
        INJECTION_SCOPE_MAP.values().forEach(InjectionScope::clear);
        INJECTION_SCOPE_MAP.clear();
        Set<Class<InjectionScope>> subTypesOf = DI.getSubTypesOf(InjectionScope.class);
        for (Class<InjectionScope> aClass : subTypesOf) {
            try {
                InjectionScope injectionScope = aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                INJECTION_SCOPE_MAP.put(injectionScope.getScopeName(), injectionScope);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.warning("could not create an instance ", e);
            }
        }
    }

    static {
        InjectionScopeManager.reInitAllScopes();
    }
}

