/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.ddi.scopes.provided;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.rapidpm.ddi.scopes.InjectionScope;

public class JVMSingletonInjectionScope
extends InjectionScope {
    private static final Map<String, Object> SINGLETONS = new ConcurrentHashMap<String, Object>();

    @Override
    public <T> T getInstance(String clazz) {
        if (SINGLETONS.containsKey(clazz)) {
            return (T)SINGLETONS.get(clazz);
        }
        return null;
    }

    @Override
    public <T> void storeInstance(Class<T> targetClassOrInterface, T instance) {
        String name = targetClassOrInterface.getName();
        if (SINGLETONS.containsKey(name)) {
            throw new RuntimeException("tried to set the Singleton twice .. " + targetClassOrInterface + " with instance " + instance);
        }
        SINGLETONS.put(name, instance);
    }

    @Override
    public void clear() {
        SINGLETONS.clear();
    }

    @Override
    public String getScopeName() {
        return JVMSingletonInjectionScope.class.getSimpleName();
    }
}

