/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.dependencies.core.logger;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.rapidpm.dependencies.core.logger.LoggingService;
import org.rapidpm.dependencies.core.logger.factory.LoggerFactory;
import org.rapidpm.dependencies.core.logger.factory.NoLogFactory;
import org.rapidpm.dependencies.core.logger.factory.StandardLoggerFactory;

public class Logger {
    public static final String RAPIDPM_LOGGING_TYPE = "rapidpm.logging.type";
    public static final String RAPIDPM_LOGGING_CLASS = "rapidpm.logging.class";
    private static volatile LoggerFactory loggerFactory;
    private static final Object FACTORY_LOCK;

    private Logger() {
    }

    public static LoggingService getLogger(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoggingService getLogger(String name) {
        if (loggerFactory == null) {
            Object object = FACTORY_LOCK;
            synchronized (object) {
                if (loggerFactory == null) {
                    String loggerType = System.getProperty(RAPIDPM_LOGGING_TYPE);
                    loggerFactory = Logger.newLoggerFactory(loggerType);
                }
            }
        }
        return loggerFactory.getLogger(name);
    }

    public static LoggerFactory newLoggerFactory(String loggerType) {
        LoggerFactory loggerFactory = null;
        String loggerClass = System.getProperty(RAPIDPM_LOGGING_CLASS);
        if (loggerClass != null) {
            loggerFactory = Logger.loadLoggerFactory(loggerClass);
        }
        if (loggerFactory == null && loggerType != null) {
            if ("log4j".equals(loggerType)) {
                loggerFactory = Logger.loadLoggerFactory("org.rapidpm.dependencies.core.logger.factory.Log4jFactory");
            } else if ("log4j2".equals(loggerType)) {
                loggerFactory = Logger.loadLoggerFactory("org.rapidpm.dependencies.core.logger.factory.Log4j2Factory");
            } else if ("slf4j".equals(loggerType)) {
                loggerFactory = Logger.loadLoggerFactory("org.rapidpm.dependencies.core.logger.factory.Slf4jFactory");
            } else if ("jdk".equals(loggerType)) {
                loggerFactory = new StandardLoggerFactory();
            } else if ("none".equals(loggerType)) {
                loggerFactory = new NoLogFactory();
            }
        }
        if (loggerFactory == null) {
            loggerFactory = new StandardLoggerFactory();
        }
        return loggerFactory;
    }

    private static LoggerFactory loadLoggerFactory(String className) {
        try {
            Class<?> forName = Class.forName(className);
            Constructor<?> declaredConstructor = forName.getDeclaredConstructor(new Class[0]);
            return (LoggerFactory)declaredConstructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        FACTORY_LOCK = new Object();
    }
}

