/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.rapidpm.dependencies.core.logger.Logger;
import org.rapidpm.dependencies.core.logger.LoggingService;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.util.ClasspathHelper;
import repacked.com.google.common.base.Predicate;
import repacked.com.google.common.base.Predicates;

public abstract class ReflectionUtils {
    public static boolean includeObject = false;
    private static List<String> primitiveNames;
    private static List<Class> primitiveTypes;
    private static List<String> primitiveDescriptors;

    public static Set<Class<?>> getAllSuperTypes(Class<?> type, Predicate<Class<?>> ... predicates) {
        LinkedHashSet result = new LinkedHashSet();
        if (type != null && (includeObject || !type.equals(Object.class))) {
            result.add(type);
            for (Class<?> supertype : ReflectionUtils.getSuperTypes(type)) {
                result.addAll(ReflectionUtils.getAllSuperTypes(supertype, new Predicate[0]));
            }
        }
        return ReflectionUtils.filter(result, predicates);
    }

    public static Set<Class<?>> getSuperTypes(Class<?> type) {
        LinkedHashSet result = new LinkedHashSet();
        if (type == null) {
            return result;
        }
        Class<?> superclass = type.getSuperclass();
        Class<?>[] interfaces = type.getInterfaces();
        if (superclass != null && (includeObject || !superclass.equals(Object.class))) {
            result.add(superclass);
        }
        if (interfaces != null && interfaces.length > 0) {
            result.addAll(Arrays.asList(interfaces));
        }
        return result;
    }

    public static Set<Method> getAllMethods(Class<?> type, Predicate<Method> ... predicates) {
        HashSet<Method> result = new HashSet<Method>();
        for (Class<?> t : ReflectionUtils.getAllSuperTypes(type, new Predicate[0])) {
            result.addAll(ReflectionUtils.getMethods(t, predicates));
        }
        return result;
    }

    public static Set<Method> getMethods(Class<?> t, Predicate<Method> ... predicates) {
        return ReflectionUtils.filter(t.isInterface() ? t.getMethods() : t.getDeclaredMethods(), predicates);
    }

    public static Set<Constructor> getAllConstructors(Class<?> type, Predicate<Constructor> ... predicates) {
        HashSet<Constructor> result = new HashSet<Constructor>();
        for (Class<?> t : ReflectionUtils.getAllSuperTypes(type, new Predicate[0])) {
            result.addAll(ReflectionUtils.getConstructors(t, predicates));
        }
        return result;
    }

    public static Set<Constructor> getConstructors(Class<?> t, Predicate<Constructor> ... predicates) {
        return ReflectionUtils.filter(t.getDeclaredConstructors(), predicates);
    }

    public static Set<Field> getAllFields(Class<?> type, Predicate<Field> ... predicates) {
        HashSet<Field> result = new HashSet<Field>();
        for (Class<?> t : ReflectionUtils.getAllSuperTypes(type, new Predicate[0])) {
            result.addAll(ReflectionUtils.getFields(t, predicates));
        }
        return result;
    }

    public static Set<Field> getFields(Class<?> type, Predicate<Field> ... predicates) {
        return ReflectionUtils.filter(type.getDeclaredFields(), predicates);
    }

    public static <T extends AnnotatedElement> Set<Annotation> getAllAnnotations(T type, Predicate<Annotation> ... predicates) {
        HashSet<Annotation> result = new HashSet<Annotation>();
        if (type instanceof Class) {
            for (Class<?> t : ReflectionUtils.getAllSuperTypes((Class)type, new Predicate[0])) {
                result.addAll(ReflectionUtils.getAnnotations(t, predicates));
            }
        } else {
            result.addAll(ReflectionUtils.getAnnotations(type, predicates));
        }
        return result;
    }

    public static <T extends AnnotatedElement> Set<Annotation> getAnnotations(T type, Predicate<Annotation> ... predicates) {
        return ReflectionUtils.filter(type.getDeclaredAnnotations(), predicates);
    }

    public static <T extends AnnotatedElement> Set<T> getAll(Set<T> elements, Predicate<T> ... predicates) {
        Predicate<T> and = Predicates.and(predicates);
        Iterable filter = elements.stream().filter(and::apply).collect(Collectors.toList());
        return Predicates.isEmpty(predicates) ? elements : StreamSupport.stream(filter.spliterator(), false).collect(Collectors.toSet());
    }

    public static <T extends Member> Predicate<T> withName(String name) {
        return input -> input != null && input.getName().equals(name);
    }

    public static <T extends Member> Predicate<T> withPrefix(String prefix) {
        return input -> input != null && input.getName().startsWith(prefix);
    }

    public static <T extends AnnotatedElement> Predicate<T> withPattern(String regex) {
        return input -> Pattern.matches(regex, input.toString());
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotation(Class<? extends Annotation> annotation) {
        return input -> input != null && input.isAnnotationPresent(annotation);
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotations(Class<? extends Annotation> ... annotations) {
        return input -> input != null && Arrays.equals(annotations, ReflectionUtils.annotationTypes(input.getAnnotations()));
    }

    private static Class<? extends Annotation>[] annotationTypes(Annotation[] annotations) {
        Class[] result = new Class[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            result[i] = annotations[i].annotationType();
        }
        return result;
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotation(Annotation annotation) {
        return input -> input != null && input.isAnnotationPresent(annotation.annotationType()) && ReflectionUtils.areAnnotationMembersMatching(input.getAnnotation(annotation.annotationType()), annotation);
    }

    private static boolean areAnnotationMembersMatching(Annotation annotation1, Annotation annotation2) {
        if (annotation2 != null && annotation1.annotationType() == annotation2.annotationType()) {
            for (Method method : annotation1.annotationType().getDeclaredMethods()) {
                try {
                    if (method.invoke((Object)annotation1, new Object[0]).equals(method.invoke((Object)annotation2, new Object[0]))) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new ReflectionsException(String.format("could not invoke method %s on annotation %s", method.getName(), annotation1.annotationType()), e);
                }
            }
            return true;
        }
        return false;
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotations(Annotation ... annotations) {
        return input -> {
            Annotation[] inputAnnotations;
            if (input != null && (inputAnnotations = input.getAnnotations()).length == annotations.length) {
                for (int i = 0; i < inputAnnotations.length; ++i) {
                    if (ReflectionUtils.areAnnotationMembersMatching(inputAnnotations[i], annotations[i])) continue;
                    return false;
                }
            }
            return true;
        };
    }

    public static Predicate<Member> withParameters(Class<?> ... types) {
        return input -> Arrays.equals(ReflectionUtils.parameterTypes(input), types);
    }

    private static Class[] parameterTypes(Member member) {
        return member != null ? (member.getClass() == Method.class ? ((Method)member).getParameterTypes() : (member.getClass() == Constructor.class ? ((Constructor)member).getParameterTypes() : null)) : null;
    }

    public static Predicate<Member> withParametersAssignableTo(Class ... types) {
        return input -> {
            Class[] parameterTypes;
            if (input != null && (parameterTypes = ReflectionUtils.parameterTypes(input)).length == types.length) {
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (parameterTypes[i].isAssignableFrom(types[i]) && (parameterTypes[i] != Object.class || types[i] == Object.class)) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    public static Predicate<Member> withParametersCount(int count) {
        return input -> input != null && ReflectionUtils.parameterTypes(input).length == count;
    }

    public static Predicate<Member> withAnyParameterAnnotation(Class<? extends Annotation> annotationClass) {
        return input -> input != null && ReflectionUtils.annotationTypes(ReflectionUtils.parameterAnnotations(input)).stream().anyMatch(input1 -> input1.equals(annotationClass));
    }

    private static Set<Class<? extends Annotation>> annotationTypes(Iterable<Annotation> annotations) {
        HashSet<Class<? extends Annotation>> result = new HashSet<Class<? extends Annotation>>();
        for (Annotation annotation : annotations) {
            result.add(annotation.annotationType());
        }
        return result;
    }

    private static Set<Annotation> parameterAnnotations(Member member) {
        Annotation[][] annotations;
        HashSet<Annotation> result = new HashSet<Annotation>();
        for (Annotation[] annotation : annotations = member instanceof Method ? ((Method)member).getParameterAnnotations() : (member instanceof Constructor ? ((Constructor)member).getParameterAnnotations() : (Annotation[][])null)) {
            Collections.addAll(result, annotation);
        }
        return result;
    }

    public static Predicate<Member> withAnyParameterAnnotation(Annotation annotation) {
        return input -> input != null && ReflectionUtils.parameterAnnotations(input).stream().anyMatch(input1 -> ReflectionUtils.areAnnotationMembersMatching(annotation, input1));
    }

    public static <T> Predicate<Field> withType(Class<T> type) {
        return input -> input != null && input.getType().equals(type);
    }

    public static <T> Predicate<Field> withTypeAssignableTo(Class<T> type) {
        return input -> input != null && type.isAssignableFrom(input.getType());
    }

    public static <T> Predicate<Method> withReturnType(Class<T> type) {
        return input -> input != null && input.getReturnType().equals(type);
    }

    public static <T> Predicate<Method> withReturnTypeAssignableTo(Class<T> type) {
        return input -> input != null && type.isAssignableFrom(input.getReturnType());
    }

    public static <T extends Member> Predicate<T> withModifier(int mod) {
        return input -> input != null && (input.getModifiers() & mod) != 0;
    }

    public static Predicate<Class<?>> withClassModifier(int mod) {
        return input -> input != null && (input.getModifiers() & mod) != 0;
    }

    public static <T> List<Class<? extends T>> forNames(Iterable<String> classes, ClassLoader ... classLoaders) {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        for (String className : classes) {
            Class<?> type = ReflectionUtils.forName(className, classLoaders);
            if (type == null) continue;
            result.add(type);
        }
        return result;
    }

    public static Class<?> forName(String typeName, ClassLoader ... classLoaders) {
        String type;
        if (ReflectionUtils.getPrimitiveNames().contains(typeName)) {
            return ReflectionUtils.getPrimitiveTypes().get(ReflectionUtils.getPrimitiveNames().indexOf(typeName));
        }
        if (typeName.contains("[")) {
            int i = typeName.indexOf("[");
            type = typeName.substring(0, i);
            String string = typeName.substring(i).replace("]", "");
            type = ReflectionUtils.getPrimitiveNames().contains(type) ? ReflectionUtils.getPrimitiveDescriptors().get(ReflectionUtils.getPrimitiveNames().indexOf(type)) : "L" + type + ";";
            type = string + type;
        } else {
            type = typeName;
            type = typeName;
        }
        ArrayList<ReflectionsException> reflectionsExceptions = new ArrayList<ReflectionsException>();
        for (ClassLoader classLoader : ClasspathHelper.classLoaders(classLoaders)) {
            if (type.contains("[")) {
                try {
                    return Class.forName(type, false, classLoader);
                }
                catch (Throwable e) {
                    reflectionsExceptions.add(new ReflectionsException("could not get type for name " + typeName, e));
                }
            }
            try {
                return classLoader.loadClass(type);
            }
            catch (Throwable e) {
                reflectionsExceptions.add(new ReflectionsException("could not get type for name " + typeName, e));
            }
        }
        LoggingService loggingService = Logger.getLogger(Reflections.class);
        if (loggingService != null) {
            for (ReflectionsException reflectionsException : reflectionsExceptions) {
                loggingService.warning("could not get type for name " + typeName + " from any class loader", reflectionsException);
            }
        }
        return null;
    }

    private static List<String> getPrimitiveNames() {
        ReflectionUtils.initPrimitives();
        return primitiveNames;
    }

    private static List<Class> getPrimitiveTypes() {
        ReflectionUtils.initPrimitives();
        return primitiveTypes;
    }

    private static List<String> getPrimitiveDescriptors() {
        ReflectionUtils.initPrimitives();
        return primitiveDescriptors;
    }

    private static void initPrimitives() {
        if (primitiveNames == null) {
            primitiveNames = Arrays.asList("boolean", "char", "byte", "short", "int", "long", "float", "double", "void");
            primitiveTypes = Arrays.asList(Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE);
            primitiveDescriptors = Arrays.asList("Z", "C", "B", "S", "I", "J", "F", "D", "V");
        }
    }

    static <T> Set<T> filter(T[] elements, Predicate<T> ... predicates) {
        return Predicates.isEmpty(predicates) ? Stream.of(elements).collect(Collectors.toSet()) : new HashSet(Arrays.stream(elements).filter(Predicates.and(predicates)::apply).collect(Collectors.toList()));
    }

    static <T> Set<T> filter(Iterable<T> elements, Predicate<T> ... predicates) {
        return Predicates.isEmpty(predicates) ? StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toSet()) : new HashSet(StreamSupport.stream(elements.spliterator(), false).filter(Predicates.and(predicates)::apply).collect(Collectors.toList()));
    }
}

