/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rapidpm.dependencies.core.logger.Logger;
import org.rapidpm.dependencies.core.logger.LoggingService;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.adapters.JavaReflectionAdapter;
import org.reflections.adapters.JavassistAdapter;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.scanners.AbstractScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.serializers.Serializer;
import org.reflections.serializers.XmlSerializer;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.FilterBuilder;
import repacked.com.google.common.base.Predicate;
import repacked.com.google.common.collect.ObjectArrays;
import repacked.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class ConfigurationBuilder
implements Configuration {
    protected MetadataAdapter metadataAdapter;
    @Nonnull
    private Set<Scanner> scanners = new HashSet<AbstractScanner>(Arrays.asList(new TypeAnnotationsScanner(), new SubTypesScanner()));
    @Nonnull
    private Set<URL> urls = new HashSet<URL>();
    @Nullable
    private Predicate<String> inputsFilter;
    private Serializer serializer;
    @Nullable
    private ExecutorService executorService;
    @Nullable
    private ClassLoader[] classLoaders;
    private boolean expandSuperTypes = true;

    /*
     * WARNING - void declaration
     */
    public static ConfigurationBuilder build(Object ... params) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (params != null) {
            void var5_7;
            Object[] objectArray = params;
            int n = objectArray.length;
            boolean bl = false;
            while (var5_7 < n) {
                Object param = objectArray[var5_7];
                if (param != null) {
                    if (param.getClass().isArray()) {
                        for (Object p : (Object[])param) {
                            if (p == null) continue;
                            parameters.add(p);
                        }
                    } else if (param instanceof Iterable) {
                        for (Object e : (Iterable)param) {
                            if (e == null) continue;
                            parameters.add(e);
                        }
                    } else {
                        parameters.add(param);
                    }
                }
                ++var5_7;
            }
        }
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        for (Object e : parameters) {
            if (!(e instanceof ClassLoader)) continue;
            loaders.add((ClassLoader)e);
        }
        ClassLoader[] classLoaders = loaders.isEmpty() ? null : loaders.toArray(new ClassLoader[loaders.size()]);
        FilterBuilder filterBuilder = new FilterBuilder();
        ArrayList<Scanner> scanners = new ArrayList<Scanner>();
        for (Object e : parameters) {
            if (e instanceof String) {
                builder.addUrls(ClasspathHelper.forPackage((String)e, classLoaders));
                filterBuilder.includePackage((String)e);
                continue;
            }
            if (e instanceof Class) {
                if (Scanner.class.isAssignableFrom((Class)e)) {
                    try {
                        builder.addScanners((Scanner)((Class)e).newInstance());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                builder.addUrls(ClasspathHelper.forClass((Class)e, classLoaders));
                filterBuilder.includePackage((Class)e);
                continue;
            }
            if (e instanceof Scanner) {
                scanners.add((Scanner)e);
                continue;
            }
            if (e instanceof URL) {
                builder.addUrls((URL)e);
                continue;
            }
            if (e instanceof ClassLoader) continue;
            if (e instanceof Predicate) {
                filterBuilder.add((Predicate)e);
                continue;
            }
            if (e instanceof ExecutorService) {
                builder.setExecutorService((ExecutorService)e);
                continue;
            }
            throw new ReflectionsException("could not use param " + e);
        }
        if (builder.getUrls().isEmpty()) {
            if (classLoaders != null) {
                builder.addUrls(ClasspathHelper.forClassLoader(classLoaders));
            } else {
                builder.addUrls(ClasspathHelper.forClassLoader());
            }
        }
        builder.filterInputsBy(filterBuilder);
        if (!scanners.isEmpty()) {
            builder.setScanners(scanners.toArray(new Scanner[scanners.size()]));
        }
        if (!loaders.isEmpty()) {
            builder.addClassLoaders(loaders);
        }
        return builder;
    }

    public ConfigurationBuilder addUrls(Collection<URL> urls) {
        this.urls.addAll(urls);
        return this;
    }

    public ConfigurationBuilder addScanners(Scanner ... scanners) {
        this.scanners.addAll(Arrays.asList(scanners));
        return this;
    }

    public ConfigurationBuilder addUrls(URL ... urls) {
        this.urls.addAll(Arrays.asList(urls));
        return this;
    }

    public ConfigurationBuilder filterInputsBy(Predicate<String> inputsFilter) {
        this.inputsFilter = inputsFilter;
        return this;
    }

    public ConfigurationBuilder addClassLoaders(Collection<ClassLoader> classLoaders) {
        return this.addClassLoaders(classLoaders.toArray(new ClassLoader[classLoaders.size()]));
    }

    public ConfigurationBuilder addClassLoaders(ClassLoader ... classLoaders) {
        this.classLoaders = this.classLoaders == null ? classLoaders : ObjectArrays.concat(this.classLoaders, classLoaders, ClassLoader.class);
        return this;
    }

    public ConfigurationBuilder forPackages(String ... packages) {
        for (String pkg : packages) {
            this.addUrls(ClasspathHelper.forPackage(pkg, new ClassLoader[0]));
        }
        return this;
    }

    @Override
    @Nonnull
    public Set<Scanner> getScanners() {
        return this.scanners;
    }

    public ConfigurationBuilder setScanners(Scanner ... scanners) {
        this.scanners.clear();
        return this.addScanners(scanners);
    }

    @Override
    @Nonnull
    public Set<URL> getUrls() {
        return this.urls;
    }

    public ConfigurationBuilder setUrls(URL ... urls) {
        this.urls = new HashSet<URL>(Arrays.asList(urls));
        return this;
    }

    @Override
    public MetadataAdapter getMetadataAdapter() {
        if (this.metadataAdapter != null) {
            return this.metadataAdapter;
        }
        try {
            this.metadataAdapter = new JavassistAdapter();
            return this.metadataAdapter;
        }
        catch (Throwable e) {
            LoggingService log = Logger.getLogger(Reflections.class);
            if (log != null) {
                log.warning("could not create JavassistAdapter, using JavaReflectionAdapter", e);
            }
            this.metadataAdapter = new JavaReflectionAdapter();
            return this.metadataAdapter;
        }
    }

    public ConfigurationBuilder setMetadataAdapter(MetadataAdapter metadataAdapter) {
        this.metadataAdapter = metadataAdapter;
        return this;
    }

    @Override
    @Nullable
    public Predicate<String> getInputsFilter() {
        return this.inputsFilter;
    }

    public void setInputsFilter(@Nullable Predicate<String> inputsFilter) {
        this.inputsFilter = inputsFilter;
    }

    @Override
    @Nullable
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ConfigurationBuilder setExecutorService(@Nullable ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer != null ? this.serializer : (this.serializer = new XmlSerializer());
    }

    public ConfigurationBuilder setSerializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    @Override
    @Nullable
    public ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }

    public void setClassLoaders(@Nullable ClassLoader[] classLoaders) {
        this.classLoaders = classLoaders;
    }

    @Override
    public boolean shouldExpandSuperTypes() {
        return this.expandSuperTypes;
    }

    public ConfigurationBuilder setUrls(@Nonnull Collection<URL> urls) {
        this.urls = new HashSet<URL>(urls);
        return this;
    }

    public ConfigurationBuilder useParallelExecutor() {
        return this.useParallelExecutor(Runtime.getRuntime().availableProcessors());
    }

    public ConfigurationBuilder useParallelExecutor(int availableProcessors) {
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("org.reflections-scanner-%d").build();
        this.setExecutorService(Executors.newFixedThreadPool(availableProcessors, factory));
        return this;
    }

    public ConfigurationBuilder setExpandSuperTypes(boolean expandSuperTypes) {
        this.expandSuperTypes = expandSuperTypes;
        return this;
    }

    public ConfigurationBuilder addClassLoader(ClassLoader classLoader) {
        return this.addClassLoaders(classLoader);
    }
}

