/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.reflections.vfs.SystemFile;
import org.reflections.vfs.Vfs;
import repacked.com.google.common.collect.AbstractIterator;

public class SystemDir
implements Vfs.Dir {
    private final File file;

    public SystemDir(File file) {
        if (!(file == null || file.isDirectory() && file.canRead())) {
            throw new RuntimeException("cannot use dir " + file);
        }
        this.file = file;
    }

    private static List<File> listFiles(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            return new ArrayList<File>(Arrays.asList(files));
        }
        return new ArrayList<File>();
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public String getPath() {
        if (this.file == null) {
            return "/NO-SUCH-DIRECTORY/";
        }
        return this.file.getPath().replace("\\", "/");
    }

    @Override
    public Iterable<Vfs.File> getFiles() {
        if (this.file == null || !this.file.exists()) {
            return Collections.emptyList();
        }
        return () -> new AbstractIterator<Vfs.File>(){
            final Stack stack = new Stack();
            {
                this.stack.addAll(SystemDir.listFiles(SystemDir.this.file));
            }

            @Override
            protected Vfs.File computeNext() {
                while (!this.stack.isEmpty()) {
                    File file = (File)this.stack.pop();
                    if (file.isDirectory()) {
                        this.stack.addAll(SystemDir.listFiles(file));
                        continue;
                    }
                    return new SystemFile(SystemDir.this, file);
                }
                return (Vfs.File)this.endOfData();
            }
        };
    }

    @Override
    public void close() {
    }
}

