/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.rapidpm.dependencies.core.logger.Logger;
import org.rapidpm.dependencies.core.logger.LoggingService;
import org.reflections.Reflections;
import org.reflections.vfs.Vfs;
import org.reflections.vfs.ZipFile;
import repacked.com.google.common.collect.AbstractIterator;

public class ZipDir
implements Vfs.Dir {
    final java.util.zip.ZipFile jarFile;

    public ZipDir(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    @Override
    public String getPath() {
        return this.jarFile.getName();
    }

    @Override
    public Iterable<Vfs.File> getFiles() {
        return () -> new AbstractIterator<Vfs.File>(){
            final Enumeration entries;
            {
                this.entries = ZipDir.this.jarFile.entries();
            }

            @Override
            protected Vfs.File computeNext() {
                while (this.entries.hasMoreElements()) {
                    ZipEntry entry = (ZipEntry)this.entries.nextElement();
                    if (entry.isDirectory()) continue;
                    return new ZipFile(ZipDir.this, entry);
                }
                return (Vfs.File)this.endOfData();
            }
        };
    }

    @Override
    public void close() {
        block2: {
            try {
                this.jarFile.close();
            }
            catch (IOException e) {
                LoggingService log = Logger.getLogger(Reflections.class);
                if (log == null) break block2;
                log.warning("Could not close JarFile", e);
            }
        }
    }

    public String toString() {
        return this.jarFile.getName();
    }
}

