/*
 * Decompiled with CFR 0.152.
 */
package repacked.com.google.common.collect;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractIterator<E>
implements Iterator<E> {
    private State state = State.NOT_READY;
    private E next;

    protected AbstractIterator() {
    }

    protected final E endOfData() {
        this.state = State.DONE;
        return null;
    }

    public final E peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    protected abstract E computeNext();

    @Override
    public final boolean hasNext() {
        this.checkState(this.state != State.FAILED);
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    @Override
    public final E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        E result = this.next;
        this.next = null;
        return result;
    }

    public void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

