/*
 * Decompiled with CFR 0.152.
 */
package repacked.com.google.common.collect;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import repacked.com.google.common.collect.Iterators;
import repacked.com.google.common.collect.MultiMapEntry;
import repacked.com.google.common.collect.Multimap;

public class MultimapImpl<KEY, VALUES>
implements Multimap<KEY, VALUES> {
    private final Map<KEY, Collection<VALUES>> multimap;
    private int totalSize;
    private Supplier<Collection<VALUES>> valuesSupplier = HashSet::new;

    public MultimapImpl(Map<KEY, Collection<VALUES>> map, Supplier<Collection<VALUES>> supplier) {
        this.multimap = map;
        this.valuesSupplier = supplier;
    }

    public MultimapImpl() {
        this.multimap = new HashMap<KEY, Collection<VALUES>>();
    }

    @Override
    public boolean put(@Nullable KEY key, @Nullable VALUES value) {
        Collection<VALUES> collection = this.multimap.get(key);
        if (collection == null) {
            collection = this.createCollection(key);
            if (collection.add(value)) {
                ++this.totalSize;
                this.multimap.put(key, collection);
                return true;
            }
            throw new AssertionError((Object)"New Collection violated the Collection spec");
        }
        if (collection.add(value)) {
            ++this.totalSize;
            return true;
        }
        return false;
    }

    private Collection<VALUES> createCollection(KEY key) {
        this.multimap.put(key, this.valuesSupplier.get());
        return this.multimap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.multimap.isEmpty();
    }

    @Override
    public Set<KEY> keySet() {
        return this.multimap.keySet();
    }

    @Override
    public Iterable<? extends Map.Entry<KEY, VALUES>> entries() {
        return this.multimap.keySet().stream().flatMap(key -> this.multimap.get(key).stream().map(value -> new MultiMapEntry<Object, Object>(key, value))).collect(Collectors.toList());
    }

    @Override
    public Collection<VALUES> get(KEY key) {
        return this.multimap.getOrDefault(key, Collections.EMPTY_LIST);
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    @Override
    public Collection<VALUES> values() {
        return this.multimap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public boolean putAll(Multimap<KEY, VALUES> multimap) {
        boolean changed = false;
        Iterable<Map.Entry<KEY, VALUES>> entries = multimap.entries();
        for (Map.Entry<KEY, VALUES> entry : entries) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    @Override
    public boolean putAll(@Nullable KEY key, Iterable<? extends VALUES> values) {
        if (values instanceof Collection) {
            Collection valueCollection = (Collection)values;
            return !valueCollection.isEmpty() && this.get(key).addAll(valueCollection);
        }
        Iterator<VALUES> valueItr = values.iterator();
        return valueItr.hasNext() && Iterators.addAll(this.get(key), valueItr);
    }

    @Override
    public Map<KEY, Collection<VALUES>> asMap() {
        return this.multimap;
    }
}

