/*
 * Decompiled with CFR 0.152.
 */
package repacked.com.google.common.collect;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import repacked.com.google.common.base.Predicate;
import repacked.com.google.common.base.Predicates;
import repacked.com.google.common.collect.Iterators;

public class Sets {
    private Sets() {
    }

    public static <E> Set<E> difference(final Set<E> set1, final Set<?> set2) {
        final Predicate<?> notInSet2 = Predicates.not(Predicates.in(set2));
        return new SetView<E>(){

            @Override
            public Iterator<E> iterator() {
                return Iterators.filter(set1.iterator(), notInSet2);
            }

            @Override
            public int size() {
                return Iterators.size(this.iterator());
            }

            @Override
            public boolean isEmpty() {
                return set2.containsAll(set1);
            }

            @Override
            public boolean contains(Object element) {
                return set1.contains(element) && !set2.contains(element);
            }
        };
    }

    public static abstract class SetView<E>
    extends AbstractSet<E> {
        private SetView() {
        }

        public Set<E> immutableCopy() {
            throw new RuntimeException("not yet factory - immutableCopy");
        }

        public <S extends Set<E>> S copyInto(S set) {
            set.addAll(this);
            return set;
        }

        @Override
        public abstract Iterator<E> iterator();
    }
}

